/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class CachingInvocationHandler
implements InvocationHandler {
    Map<MethodCallState, AtomicReference<Object>> _methodCallStateCache = new ConcurrentHashMap<MethodCallState, AtomicReference<Object>>();
    Object _delegate;

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        MethodCallState methodCallState = new MethodCallState(object, method, objectArray);
        AtomicReference<Object> atomicReference = this._methodCallStateCache.get(methodCallState);
        if (atomicReference == null) {
            atomicReference = new AtomicReference();
            atomicReference.set(method.invoke(this._delegate, objectArray));
            this._methodCallStateCache.put(methodCallState, atomicReference);
        }
        return atomicReference.get();
    }

    public void clearCache() {
        this._methodCallStateCache.clear();
    }

    static class MethodCallState {
        Object _proxy;
        Method _method;
        Object[] _parameters;
        Object _returnValue;

        MethodCallState(Object object, Method method, Object[] objectArray) {
            this._proxy = object;
            this._method = method;
            this._parameters = objectArray;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this._method == null ? 0 : this._method.hashCode());
            n = 31 * n + Arrays.hashCode(this._parameters);
            n = 31 * n + (this._proxy == null ? 0 : this._proxy.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            MethodCallState methodCallState = (MethodCallState)object;
            if (this._method == null ? methodCallState._method != null : !this._method.equals(methodCallState._method)) {
                return false;
            }
            if (!Arrays.equals(this._parameters, methodCallState._parameters)) {
                return false;
            }
            return !(this._proxy == null ? methodCallState._proxy != null : !this._proxy.equals(methodCallState._proxy));
        }

        public void setReturnValue(Object object) {
            this._returnValue = object;
        }
    }
}

