/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import net.model3.lang.Measurement;
import net.model3.lang.Throughput;
import net.model3.lang.TimeDuration;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class ByteSize
extends Measurement<ByteSize> {
    private static final long serialVersionUID = 6482725121928870161L;
    private static final Logger logger = LoggerHelper.getLogger();
    private static final Measurement.MetaMeasurement _metaMeasurement = new Measurement.MetaMeasurement("byte size");
    private static final Measurement.MetaMeasurement.Unit Byte = _metaMeasurement.addUnit(1L, "byte", "bytes", "B", true, new String[0]);
    private static final Measurement.MetaMeasurement.Unit Kilobyte = _metaMeasurement.addUnit(1024L, "kilobyte", "kilobytes", "KB", true, new String[0]);
    private static final Measurement.MetaMeasurement.Unit Megabyte = _metaMeasurement.addUnit(0x100000L, "megabyte", "megabytes", "MB", true, new String[0]);
    private static final Measurement.MetaMeasurement.Unit Gigabyte = _metaMeasurement.addUnit(0x40000000L, "gigabyte", "gigabytes", "GB", true, new String[0]);
    private static final Measurement.MetaMeasurement.Unit Terabyte = _metaMeasurement.addUnit(0x10000000000L, "terabyte", "terabytes", "TB", true, new String[0]);
    public static final ByteSize ZERO = new ByteSize(0L);
    public static final ByteSize MAX = new ByteSize(Long.MAX_VALUE);

    public ByteSize(long l) {
        super(l, Byte);
    }

    public ByteSize(String string) {
        super(string);
    }

    @Override
    protected Measurement.MetaMeasurement getMetaMeasurement() {
        return _metaMeasurement;
    }

    public long inBytes() {
        return this.getValue();
    }

    public double inKilobytes() {
        return this.convertTo(Kilobyte);
    }

    public double inMegabytes() {
        return this.convertTo(Megabyte);
    }

    public double inGigabytes() {
        return this.convertTo(Gigabyte);
    }

    @Override
    public String toString() {
        return this.toEstimatedString(false);
    }

    public boolean isGreaterThan(ByteSize byteSize) {
        return this.inBytes() > byteSize.inBytes();
    }

    public Throughput asThroughput(TimeDuration timeDuration) {
        return new Throughput(this, timeDuration);
    }
}

