/*
 * Decompiled with CFR 0.152.
 */
package net.model3.jdbc.dbmetadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.model3.bean.converters.ConverterAdapter;
import net.model3.collections.ListX;
import net.model3.io.IOHelper;
import net.model3.jdbc.QueryTemplate;
import net.model3.jdbc.dbmetadata.DataTypes;
import net.model3.jdbc.dbmetadata.DatabaseMeta;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class ISeriesDatabaseMeta
extends DatabaseMeta {
    Logger logger = LoggerHelper.getLogger();
    List<String> _libraryList;
    String _libraryListInClause;

    public static List<String> extractLibraryListFromURL(String string) {
        List<String> list = ListX.create();
        String string2 = ";libraries=";
        int n = string.indexOf(string2);
        if (n >= 0) {
            int n2 = n + string2.length();
            int n3 = string.indexOf(";", n2);
            String string3 = n3 == -1 ? string.substring(n2) : string.substring(n2, n3);
            for (String string4 : string3.split(",")) {
                list.add(string4);
            }
        }
        return list;
    }

    public ISeriesDatabaseMeta(DataSource dataSource, DataTypes dataTypes) {
        super(dataSource, dataTypes);
        Connection connection = null;
        try {
            this.init(dataSource.getConnection());
        }
        catch (SQLException sQLException) {
            throw ExceptionPropagator.throwUnchecked(sQLException);
        }
        finally {
            IOHelper.close(connection);
        }
    }

    public ISeriesDatabaseMeta(Connection connection, DataTypes dataTypes) {
        super(connection, dataTypes);
        try {
            this.init(connection);
        }
        catch (SQLException sQLException) {
            throw ExceptionPropagator.throwUnchecked(sQLException);
        }
    }

    void init(Connection connection) throws SQLException {
        this._libraryList = ISeriesDatabaseMeta.extractLibraryListFromURL(connection.getMetaData().getURL());
        this._libraryListInClause = "(" + StringX.join(this._libraryList, ",", new ConverterAdapter<String>(){

            @Override
            public String valueToString(String string) {
                return "'" + string.trim() + "'";
            }
        }) + ")";
    }

    @Override
    public Map<String, Integer> getPrimaryKeys(DatabaseMetaData databaseMetaData, final String string) throws SQLException {
        final Map<String, Integer> map = super.getPrimaryKeys(databaseMetaData, string);
        try {
            new QueryTemplate<Void>(databaseMetaData.getConnection(), "select DBKFLD, DBKPOS from QADBKFLD where DBKLIB in " + this._libraryListInClause + " and DBKFIL = ?"){

                @Override
                public void prepareQuery(PreparedStatement preparedStatement) throws SQLException {
                    preparedStatement.setString(1, string.toUpperCase());
                }

                @Override
                public Void processRow(ResultSet resultSet) throws SQLException {
                    map.put(resultSet.getString(1).trim(), resultSet.getInt(2));
                    return null;
                }
            }.execute();
        }
        catch (Exception exception) {
            this.logger.warn((Object)"unable to get primary key metadata for {} no espaccpth table found", (Object)string);
        }
        return map;
    }
}

