/*
 * Decompiled with CFR 0.152.
 */
package net.model3.jdbc.dbmetadata;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.model3.io.IOHelper;
import net.model3.jdbc.dbmetadata.DataTypes;
import net.model3.jdbc.dbmetadata.DatabaseMeta;
import net.model3.jdbc.dbmetadata.DatabaseMetaFactory;
import net.model3.jdbc.dbmetadata.ISeriesDatabaseMeta;
import net.model3.lang.ExceptionPropagator;

@Singleton
public class DatabaseMetaFactoryImpl
implements DatabaseMetaFactory {
    @Inject
    DataTypes _dataTypes;

    @Override
    public DatabaseMeta createDatabaseMeta(Connection connection) {
        try {
            if (connection.getMetaData().getURL().contains(":as400:")) {
                return new ISeriesDatabaseMeta(connection, this._dataTypes);
            }
            return new DatabaseMeta(connection, this._dataTypes);
        }
        catch (SQLException sQLException) {
            throw ExceptionPropagator.throwUnchecked(sQLException);
        }
    }

    @Override
    public DatabaseMeta createDatabaseMeta(DataSource dataSource) {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            if (connection.getMetaData().getURL().contains(":as400:")) {
                ISeriesDatabaseMeta iSeriesDatabaseMeta = new ISeriesDatabaseMeta(dataSource, this._dataTypes);
                return iSeriesDatabaseMeta;
            }
            DatabaseMeta databaseMeta = new DatabaseMeta(dataSource, this._dataTypes);
            return databaseMeta;
        }
        catch (SQLException sQLException) {
            throw ExceptionPropagator.throwUnchecked(sQLException);
        }
        finally {
            IOHelper.close(connection);
        }
    }
}

