/*
 * Decompiled with CFR 0.152.
 */
package net.model3.jdbc.dbmetadata;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import net.model3.collections.CaseInsensitiveMapWrapper;
import net.model3.collections.GeneratedMap;
import net.model3.collections.ListX;
import net.model3.collections.MapX;
import net.model3.collections.SetX;
import net.model3.io.IOHelper;
import net.model3.jdbc.dbmetadata.ColumnMeta;
import net.model3.jdbc.dbmetadata.DataTypes;
import net.model3.jdbc.dbmetadata.TableMeta;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

@Singleton
public class DatabaseMeta {
    static final Logger logger = LoggerHelper.getLogger();
    public final DataTypes dataTypes;
    protected ConnectionProvider _connectionProvider;
    protected final Map<String, TableMeta> tables = Collections.synchronizedMap(new CaseInsensitiveMapWrapper<TableMeta>(new GeneratedMap<String, TableMeta>(){

        @Override
        public TableMeta generate(String string) {
            return DatabaseMeta.this.createTableMeta(string);
        }
    }));

    @Inject
    public DatabaseMeta(final DataSource dataSource, DataTypes dataTypes) {
        this.dataTypes = dataTypes;
        this._connectionProvider = new ConnectionProvider(){

            @Override
            public Connection get() throws SQLException {
                return dataSource.getConnection();
            }

            @Override
            public boolean externallyManaged() {
                return false;
            }

            @Override
            public String jdbcUrl() {
                Connection connection = null;
                try {
                    connection = dataSource.getConnection();
                    String string = connection.getMetaData().getURL();
                    return string;
                }
                catch (Exception exception) {
                    throw ExceptionPropagator.throwUnchecked(exception);
                }
                finally {
                    IOHelper.close(connection);
                }
            }
        };
    }

    public DatabaseMeta(final Connection connection, DataTypes dataTypes) {
        this.dataTypes = dataTypes;
        this._connectionProvider = new ConnectionProvider(){

            @Override
            public Connection get() throws SQLException {
                return connection;
            }

            @Override
            public boolean externallyManaged() {
                return true;
            }

            @Override
            public String jdbcUrl() {
                try {
                    return connection.getMetaData().getURL();
                }
                catch (Exception exception) {
                    throw ExceptionPropagator.throwUnchecked(exception);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableMeta createTableMeta(String string) {
        Connection connection = null;
        try {
            ResultSet resultSet;
            DatabaseMetaData databaseMetaData;
            block14: {
                TableMeta tableMeta;
                connection = this._connectionProvider.get();
                databaseMetaData = connection.getMetaData();
                logger.debug((Object)"createTableMeta({})  url = {}", (Object)string, (Object)databaseMetaData.getURL());
                resultSet = databaseMetaData.getTables(null, null, string, null);
                try {
                    boolean bl = true;
                    if (!resultSet.next()) {
                        IOHelper.close(resultSet);
                        string = string.toLowerCase();
                        resultSet = databaseMetaData.getTables(null, null, string, null);
                        if (!resultSet.next()) {
                            IOHelper.close(resultSet);
                            string = string.toUpperCase();
                            resultSet = databaseMetaData.getTables(null, null, string, null);
                            if (!resultSet.next()) {
                                bl = false;
                            }
                        }
                    }
                    IOHelper.close(resultSet);
                    if (!bl) break block14;
                    TableMeta tableMeta2 = new TableMeta(string, this.createColumns(databaseMetaData, string));
                    tableMeta = tableMeta2 = this.resolveTableMeta(tableMeta2);
                }
                catch (Throwable throwable) {
                    try {
                        IOHelper.close(resultSet);
                        throw throwable;
                    }
                    catch (Exception exception) {
                        throw ExceptionPropagator.throwUnchecked(exception);
                    }
                }
                IOHelper.close(resultSet);
                return tableMeta;
            }
            logger.warn((Object)"unable to find table meta for {} - {}", (Object)string, (Object)databaseMetaData.getURL());
            TableMeta tableMeta = null;
            IOHelper.close(resultSet);
            return tableMeta;
        }
        finally {
            if (!this._connectionProvider.externallyManaged()) {
                IOHelper.close(connection);
            }
        }
    }

    protected List<ColumnMeta> createColumns(DatabaseMetaData databaseMetaData, String string) throws SQLException {
        Set set = SetX.create();
        List<ColumnMeta> list = ListX.create();
        Map<String, Integer> map = this.getPrimaryKeys(databaseMetaData, string);
        ResultSet resultSet = databaseMetaData.getColumns(null, null, string, null);
        while (resultSet.next()) {
            ColumnMeta columnMeta = this.createColumn(string, resultSet, map);
            if (set.contains(columnMeta.getName())) {
                logger.warn((Object)("metadata retrieval error, duplicate column " + string + "." + columnMeta.getName() + " found in database " + databaseMetaData.getURL()));
                continue;
            }
            list.add(columnMeta);
            set.add(columnMeta.getName());
        }
        return list;
    }

    protected ColumnMeta createColumn(String string, ResultSet resultSet, Map<String, Integer> map) throws SQLException {
        ColumnMeta columnMeta = new ColumnMeta(string, map.get(resultSet.getString("COLUMN_NAME")), resultSet, this.dataTypes);
        columnMeta = this.resolveColumn(columnMeta);
        return columnMeta;
    }

    protected ColumnMeta resolveColumn(ColumnMeta columnMeta) {
        return columnMeta;
    }

    protected TableMeta resolveTableMeta(TableMeta tableMeta) {
        return tableMeta;
    }

    public Map<String, Integer> getPrimaryKeys(DatabaseMetaData databaseMetaData, String string) throws SQLException {
        String string2;
        Map<String, Integer> map = this.getPrimaryKeys(databaseMetaData, string, null);
        if (map.isEmpty() && (string2 = this.getSchema(databaseMetaData, string)) != null) {
            map = this.getPrimaryKeys(databaseMetaData, string, string2);
        }
        return map;
    }

    String getSchema(DatabaseMetaData databaseMetaData, String string) throws SQLException {
        ResultSet resultSet = databaseMetaData.getTables(null, null, string, null);
        if (resultSet.next()) {
            return resultSet.getString("TABLE_SCHEM");
        }
        return null;
    }

    Map<String, Integer> getPrimaryKeys(DatabaseMetaData databaseMetaData, String string, String string2) throws SQLException {
        Map<String, Integer> map = MapX.create();
        Connection connection = databaseMetaData.getConnection();
        try {
            ResultSet resultSet = connection.getMetaData().getPrimaryKeys(null, string2, string);
            while (resultSet.next()) {
                map.put(resultSet.getString("COLUMN_NAME").trim(), resultSet.getInt("KEY_SEQ"));
            }
        }
        catch (Exception exception) {
            throw ExceptionPropagator.throwUnchecked(exception);
        }
        return map;
    }

    public TableMeta getTable(String string) {
        return this.getTable(string, true);
    }

    public TableMeta getTable(String string, boolean bl) {
        TableMeta tableMeta = this.tables.get(string);
        if (tableMeta == null && bl) {
            throw new RuntimeException("Table " + string + " not found in database " + this._connectionProvider.jdbcUrl());
        }
        return tableMeta;
    }

    static interface ConnectionProvider {
        public Connection get() throws SQLException;

        public boolean externallyManaged();

        public String jdbcUrl();
    }
}

