/*
 * Decompiled with CFR 0.152.
 */
package net.model3.jdbc.dbmetadata;

import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Map;
import net.model3.bean.converters.BigDecimalConverter;
import net.model3.bean.converters.BigIntegerConverter;
import net.model3.bean.converters.Converter;
import net.model3.bean.converters.IntegerConverter;
import net.model3.bean.converters.StringConverter;
import net.model3.collections.MapX;
import net.model3.jdbc.dbmetadata.DataType;
import net.model3.lang.ExceptionPropagator;
import net.model3.text.ThreadSafeSimpleDateFormat;

@Singleton
public class DataTypes {
    final Map<Integer, DataType> typesToValues = MapX.create();
    public final DataType BINARY = this.create(-2, "BINARY", byte[].class, false, new StringConverter());
    public final DataType CHAR = this.create(1, "CHAR", String.class, false, new StringConverter());
    public final DataType SMALLINT = this.create(5, "SMALLINT", Short.class, false, new StringConverter());
    public final DataType BIGINT = this.create(-5, "BIGINT", BigInteger.class, true, new BigIntegerConverter());
    public final DataType NUMERIC = this.create(2, "NUMERIC", BigDecimal.class, true, new BigDecimalConverter());
    public final DataType DECIMAL = this.create(3, "DECIMAL", BigDecimal.class, true, new BigDecimalConverter());
    public final DataType INTEGER = this.create(4, "INTEGER", Integer.class, true, new IntegerConverter());
    public final DataType VARCHAR = this.create(12, "VARCHAR", String.class, false, new StringConverter());
    public final DataType LONGVARCHAR = this.create(-1, "LONGVARCHAR", String.class, false, new StringConverter());
    public final DataType DATE = this.create(91, "DATE", Date.class, true, new DateFormatConverter<Date>("yyyy-MM-dd"){

        @Override
        Date create(java.util.Date date) {
            return new Date(date.getTime());
        }
    });
    public final DataType TIME = this.create(92, "TIME", Time.class, true, new DateFormatConverter<Time>("HH-mm-ss"){

        @Override
        Time create(java.util.Date date) {
            return new Time(date.getTime());
        }
    });
    public final DataType TIMESTAMP = this.create(93, "TIMESTAMP", Timestamp.class, true, new DateFormatConverter<Timestamp>("yyyy-MM-dd-HH-mm-ss"){

        @Override
        Timestamp create(java.util.Date date) {
            return new Timestamp(date.getTime());
        }
    });

    private DataType create(int n, String string, Class<?> clazz, boolean bl, Converter<?> converter) {
        DataType dataType = new DataType(n, string, clazz, bl, converter);
        this.typesToValues.put(dataType.dataType, dataType);
        return dataType;
    }

    public DataType getType(int n) {
        DataType dataType = this.typesToValues.get(n);
        if (dataType == null) {
            throw new RuntimeException("unable to find data type " + n);
        }
        return dataType;
    }

    public DataType getType(Class<?> clazz) {
        for (DataType dataType : this.typesToValues.values()) {
            if (!dataType.javaClass.equals(clazz)) continue;
            return dataType;
        }
        throw new RuntimeException("unable to find data type for java type " + clazz);
    }

    abstract class DateFormatConverter<T extends java.util.Date>
    implements Converter<T> {
        final DateFormat formatter;

        DateFormatConverter(String string) {
            this.formatter = new ThreadSafeSimpleDateFormat(string);
        }

        @Override
        public boolean canConvertType(Class<?> clazz) {
            return false;
        }

        abstract T create(java.util.Date var1);

        @Override
        public T stringToValue(Class<?> clazz, String string) {
            try {
                return this.create(this.formatter.parse(string));
            }
            catch (Exception exception) {
                throw ExceptionPropagator.throwUnchecked(exception);
            }
        }

        @Override
        public String valueToString(T t) {
            return this.formatter.format((java.util.Date)t);
        }
    }
}

