/*
 * Decompiled with CFR 0.152.
 */
package net.model3.jdbc.dbmetadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import net.model3.collections.MapX;
import net.model3.jdbc.dbmetadata.DataType;
import net.model3.jdbc.dbmetadata.DataTypes;

public class ColumnMeta {
    String _tableName;
    String _name;
    String _label;
    int _size;
    int _bufferSize;
    int _decimalDigits;
    int _ordinalPosition;
    Integer _primaryKeyIndex;
    Map<String, Object> _metadata = MapX.create();
    DataType _dataType;

    public ColumnMeta(String string, Integer n, ResultSet resultSet, DataTypes dataTypes) throws SQLException {
        this._tableName = string;
        this._name = resultSet.getString("COLUMN_NAME");
        this._size = resultSet.getInt("COLUMN_SIZE");
        this._bufferSize = resultSet.getInt("BUFFER_LENGTH");
        this._decimalDigits = resultSet.getInt("DECIMAL_DIGITS");
        this._label = resultSet.getString("REMARKS");
        this._ordinalPosition = resultSet.getInt("ORDINAL_POSITION");
        this._primaryKeyIndex = n;
        this._dataType = dataTypes.getType(resultSet.getInt("DATA_TYPE"));
    }

    public ColumnMeta(String string, Integer n, String string2, String string3, DataType dataType, int n2, int n3) {
        this._tableName = string;
        this._primaryKeyIndex = n;
        this._name = string2;
        this._label = string3;
        this._dataType = dataType;
        this._size = n2;
        this._decimalDigits = n3;
        this._bufferSize = -1;
        this._ordinalPosition = -1;
    }

    public DataType getDataType() {
        return this._dataType;
    }

    public boolean isNumeric() {
        return this.getDataType().numeric;
    }

    public String getName() {
        return this._name;
    }

    public String getLabel() {
        return this._label;
    }

    public String getTableName() {
        return this._tableName;
    }

    public void setTableName(String string) {
        this._tableName = string;
    }

    public int getSize() {
        return this._size;
    }

    public void setSize(int n) {
        this._size = n;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int n) {
        this._bufferSize = n;
    }

    public int getDecimalDigits() {
        return this._decimalDigits;
    }

    public void setDecimalDigits(int n) {
        this._decimalDigits = n;
    }

    public int getOrdinalPosition() {
        return this._ordinalPosition;
    }

    public void setOrdinalPosition(int n) {
        this._ordinalPosition = n;
    }

    public Integer getPrimaryKeyIndex() {
        return this._primaryKeyIndex;
    }

    public void setPrimaryKeyIndex(Integer n) {
        this._primaryKeyIndex = n;
    }

    public Map<String, Object> getMetadata() {
        return this._metadata;
    }

    public void setMetadata(Map<String, Object> map) {
        this._metadata = map;
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setLabel(String string) {
        this._label = string;
    }

    public String toString() {
        return this._name;
    }
}

