/*
 * Decompiled with CFR 0.152.
 */
package net.model3.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import net.model3.collections.ListX;
import net.model3.io.IOHelper;
import net.model3.lang.ExceptionPropagator;

public abstract class QueryTemplate<T> {
    DataSource _dataSource;
    Connection _connection;
    String _sql;
    boolean _manageConnection = true;

    public QueryTemplate(DataSource dataSource, String string) {
        this._dataSource = dataSource;
        this._sql = string;
        this._manageConnection = true;
    }

    public QueryTemplate(Connection connection, String string) {
        this._connection = connection;
        this._sql = string;
        this._manageConnection = false;
    }

    public void prepareQuery(PreparedStatement preparedStatement) throws SQLException {
    }

    public abstract T processRow(ResultSet var1) throws SQLException;

    public List<T> execute() {
        List list;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (this._connection == null) {
                this._connection = this._dataSource.getConnection();
            }
            List list2 = ListX.create();
            preparedStatement = this._connection.prepareStatement(this._sql);
            this.prepareQuery(preparedStatement);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                list2.add(this.processRow(resultSet));
            }
            list = list2;
        }
        catch (Exception exception) {
            try {
                throw ExceptionPropagator.throwUnchecked(exception);
            }
            catch (Throwable throwable) {
                IOHelper.close(resultSet);
                IOHelper.close(preparedStatement);
                if (this._manageConnection) {
                    IOHelper.close(this._connection);
                }
                throw throwable;
            }
        }
        IOHelper.close(resultSet);
        IOHelper.close(preparedStatement);
        if (this._manageConnection) {
            IOHelper.close(this._connection);
        }
        return list;
    }
}

