/*
 * Decompiled with CFR 0.152.
 */
package net.model3.jdbc;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class JdbcHelper {
    private static final Logger logger = LoggerHelper.getLogger();

    public static void close(Connection connection) {
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (Exception exception) {
            logger.debug((Object)"error while closing connection {}", (Object)connection, (Object)exception);
        }
    }

    public static void close(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            logger.debug((Object)"error while closing connection {}", (Object)statement, (Object)exception);
        }
    }

    public static void close(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception exception) {
            logger.debug((Object)"error while closing ResultSet {}", (Object)resultSet, (Object)exception);
        }
    }

    public static void rollback(Connection connection) {
        try {
            connection.rollback();
        }
        catch (Exception exception) {
            logger.warn((Object)"error rolling back", (Object)exception);
        }
    }

    public static String resultSetToString(ResultSet resultSet) throws SQLException {
        String string;
        int n;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
            string = StringX.padRight(resultSetMetaData.getColumnName(n), resultSetMetaData.getColumnDisplaySize(n) + 1);
            printWriter.print(string);
        }
        printWriter.println();
        while (resultSet.next()) {
            for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
                string = StringX.padRight(resultSet.getObject(n), resultSetMetaData.getColumnDisplaySize(n) + 1);
                printWriter.print(string);
            }
            printWriter.println();
        }
        printWriter.close();
        return stringWriter.toString();
    }

    public static void executeUpdate(Connection connection, String string) {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

