/*
 * Decompiled with CFR 0.152.
 */
package net.model3.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Stack;
import net.model3.servlet.HtmlProcessor;

public class XmlWriter
extends PrintWriter {
    private boolean _prettyPrint = false;
    private Stack<String> _elementStack = new Stack();

    public XmlWriter(File file, String string) throws FileNotFoundException, UnsupportedEncodingException {
        super(file, string);
    }

    public XmlWriter(File file) throws FileNotFoundException {
        super(file);
    }

    public XmlWriter(OutputStream outputStream, boolean bl) {
        super(outputStream, bl);
    }

    public XmlWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public XmlWriter(String string, String string2) throws FileNotFoundException, UnsupportedEncodingException {
        super(string, string2);
    }

    public XmlWriter(String string) throws FileNotFoundException {
        super(string);
    }

    public XmlWriter(Writer writer, boolean bl) {
        super(writer, bl);
    }

    public XmlWriter(Writer writer) {
        super(writer);
    }

    public void simpleElement(String string, String string2) {
        string = string.trim();
        this.outputIndent();
        this.print("<");
        this.print(string);
        this.print(">");
        this.print(HtmlProcessor.encodeSpecialCharacters(string2, "/ .;:,?[]{}|`~!@#$%^*()-_+="));
        this.print("</");
        this.print(string);
        this.print(">");
        this.outputEndOfLine();
    }

    void outputIndent() {
        if (this.isPrettyPrint()) {
            for (int i = 0; i < this._elementStack.size(); ++i) {
                this.print("\t");
            }
        }
    }

    void outputEndOfLine() {
        if (this.isPrettyPrint()) {
            this.print("\n");
        }
    }

    public void startElement(String string) {
        this.outputIndent();
        this._elementStack.push(string);
        this.print("<");
        this.print(string);
        this.print(">");
        this.outputEndOfLine();
    }

    public void endElement(String string) {
        String string2 = this._elementStack.pop();
        if (!string.equals(string2)) {
            throw new RuntimeException("expected element name " + string + " does not match current element level " + string2);
        }
        this.outputIndent();
        this.print("</");
        this.print(string2);
        this.print(">");
        this.outputEndOfLine();
    }

    public void setPrettyPrint(boolean bl) {
        this._prettyPrint = bl;
    }

    public boolean isPrettyPrint() {
        return this._prettyPrint;
    }
}

