/*
 * Decompiled with CFR 0.152.
 */
package net.model3.io;

import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimestampedOutputStream
extends PrintStream {
    private long nextTimestamp_;
    private long intervalBetweenTimeStamps_;
    private SimpleDateFormat sdf_ = new SimpleDateFormat("yyyy-MM-dd-EEE HH:mm:ss");

    public TimestampedOutputStream(OutputStream outputStream) {
        this(outputStream, 300000L);
    }

    public TimestampedOutputStream(OutputStream outputStream, long l) {
        super(outputStream);
        this.intervalBetweenTimeStamps_ = l;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (System.currentTimeMillis() > this.nextTimestamp_) {
            this.nextTimestamp_ = System.currentTimeMillis() + this.intervalBetweenTimeStamps_;
            this.println("TIMESTAMP: " + this.sdf_.format(new Date()));
        }
        super.write(byArray, n, n2);
    }
}

