/*
 * Decompiled with CFR 0.152.
 */
package net.model3.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.SocketException;
import net.model3.io.IOHelper;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class Pipe
implements Runnable {
    private static final Logger logger = LoggerHelper.getLogger();
    private InputStream in_;
    private OutputStream out_;
    private Reader reader_;
    private Writer writer_;

    public Pipe(InputStream inputStream, OutputStream outputStream) {
        this.in_ = inputStream;
        this.out_ = outputStream;
    }

    public Pipe(Reader reader, Writer writer) {
        this.reader_ = reader;
        this.writer_ = writer;
    }

    public void process() {
        if (this.reader_ == null) {
            this.processStreams();
        } else {
            this.processReader();
        }
    }

    private void processReader() {
        try {
            int n;
            char[] cArray = new char[8192];
            while ((n = this.reader_.read(cArray)) != -1) {
                logger.trace((Object)"forwarding {} bytes", (Object)n);
                this.writer_.write(cArray, 0, n);
                this.writer_.flush();
            }
            this.reader_.close();
            this.writer_.close();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    @Override
    public void run() {
        this.process();
    }

    private void processStreams() {
        block10: {
            try {
                int n;
                byte[] byArray = new byte[8192];
                while ((n = this.in_.read(byArray)) != -1) {
                    logger.trace((Object)"forwarding {} bytes", (Object)n);
                    this.out_.write(byArray, 0, n);
                    this.out_.flush();
                }
            }
            catch (SocketException socketException) {
                if (socketException.getMessage().equals("Socket closed")) {
                    break block10;
                }
                throw ExceptionPropagator.wrap(socketException);
            }
            catch (Exception exception) {
                throw ExceptionPropagator.wrap(exception);
            }
            finally {
                IOHelper.close(this.in_);
                IOHelper.close(this.out_);
            }
        }
    }
}

