/*
 * Decompiled with CFR 0.152.
 */
package net.model3.io;

import java.io.IOException;
import java.io.InputStream;

public abstract class InputStreamProgressMonitor
extends InputStream {
    InputStream _delegate;
    int _readCount = 0;
    int _minimumIncrement = 1024;
    int _nextUpdate = 0;

    public InputStreamProgressMonitor(InputStream inputStream) {
        this._delegate = inputStream;
    }

    @Override
    public int available() throws IOException {
        return this._delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.updateReadCount(this._readCount, true);
        this._delegate.close();
    }

    @Override
    public void mark(int n) {
        this._delegate.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this._delegate.markSupported();
    }

    @Override
    public int read() throws IOException {
        int n = this._delegate.read();
        if (n != -1) {
            this.incremementReadCount(1);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.incremementReadCount(this._delegate.read(byArray, n, n2));
    }

    int incremementReadCount(int n) {
        if (n > 0) {
            int n2 = this._readCount;
            this._readCount += n;
            if (this._readCount >= this._nextUpdate) {
                this.updateReadCount(this._readCount, false);
                this._nextUpdate = this._readCount + this._minimumIncrement;
            }
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.incremementReadCount(this._delegate.read(byArray));
    }

    public int getReadCount() {
        return this._readCount;
    }

    @Override
    public void reset() throws IOException {
        this._delegate.reset();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.incremementReadCount((int)this._delegate.skip(l));
    }

    protected abstract void updateReadCount(int var1, boolean var2);
}

