/*
 * Decompiled with CFR 0.152.
 */
package net.model3.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Socket;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.model3.collections.ListX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class IOHelper {
    private static final Logger logger = LoggerHelper.getLogger();

    public static byte[] serializeObject(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static <T> T deserializeObject(InputStream inputStream) {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            Object object2 = object;
            return (T)object2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            IOHelper.close(inputStream);
        }
    }

    public static <T> T deserializeObject(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            byteArrayInputStream.close();
            return (T)object;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static List<String> readLines(InputStream inputStream) {
        try {
            Object object;
            List<String> list = ListX.create();
            if (inputStream != null) {
                String string;
                object = new BufferedReader(new InputStreamReader(inputStream));
                while ((string = ((BufferedReader)object).readLine()) != null) {
                    list.add(string);
                }
            }
            object = list;
            return object;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            IOHelper.close(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(Reader reader) {
        try {
            Object object;
            List list = ListX.create();
            if (reader != null) {
                object = new BufferedReader(reader);
                try {
                    String string;
                    while ((string = ((BufferedReader)object).readLine()) != null) {
                        list.add(string);
                    }
                }
                finally {
                    IOHelper.close((Reader)object);
                }
            }
            object = list;
            return object;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            IOHelper.close(reader);
        }
    }

    public static String readFully(Reader reader) {
        try {
            int n;
            StringWriter stringWriter = new StringWriter();
            char[] cArray = new char[8192];
            while ((n = reader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n);
            }
            stringWriter.close();
            String string = stringWriter.toString();
            return string;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            IOHelper.close(reader);
        }
    }

    public static void close(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                logger.debug((Object)"error closing connection {}", (Object)connection, (Object)exception);
            }
        }
    }

    public static void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static byte[] readFully(InputStream inputStream) {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            IOHelper.close(inputStream);
        }
    }

    public static void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                logger.debug((Object)"error closing {}", (Object)resultSet, (Object)exception);
            }
        }
    }

    public static void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                logger.debug((Object)"error closing {}", (Object)statement, (Object)exception);
            }
        }
    }

    public static byte[] gzip(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.flush();
            gZIPOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static byte[] gunzip(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            byte[] byArray2 = IOHelper.readFully(gZIPInputStream);
            gZIPInputStream.close();
            return byArray2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void writeStringToStream(OutputStream outputStream, String string) throws IOException {
        try {
            outputStream.write(string.getBytes());
            outputStream.flush();
        }
        finally {
            IOHelper.close(outputStream);
        }
    }
}

