/*
 * Decompiled with CFR 0.152.
 */
package net.model3.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.model3.lang.ExceptionPropagator;

public class BytesBuilder {
    private static final int BUFFER_SIZE = 30720;
    private byte[] finalBuffer_;

    public BytesBuilder(InputStream inputStream) {
        this(inputStream, Integer.MAX_VALUE);
    }

    public BytesBuilder(InputStream inputStream, int n) {
        try {
            int n2;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            int n3 = 0;
            byte[] byArray = new byte[30720];
            int n4 = 0;
            int n5 = byArray.length;
            while ((n2 = dataInputStream.read(byArray, n4, n5)) != -1) {
                if (n4 == 0) {
                    arrayList.add(byArray);
                }
                n3 += n2;
                if (n2 == n5) {
                    n4 = 0;
                    n5 = byArray.length;
                    byArray = new byte[30720];
                } else {
                    n5 = byArray.length - (n4 += n2);
                }
                if (n3 <= n) continue;
                throw new IOException("received  bytes and " + n + " is the maximum bytes allowed.");
            }
            this.finalBuffer_ = BytesBuilder.coalesceBuffers(arrayList, n3);
            return;
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap(iOException);
        }
    }

    public static byte[] coalesceBuffers(List<byte[]> list, int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (byte[] byArray2 : list) {
            if (byArray2.length > n - n2) {
                System.arraycopy(byArray2, 0, byArray, n2, n - n2);
                break;
            }
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            n2 += byArray2.length;
        }
        return byArray;
    }

    public int getByteCount() {
        return this.finalBuffer_.length;
    }

    public byte[] asBytes() {
        return this.finalBuffer_;
    }

    public String asString() {
        return new String(this.asBytes());
    }
}

