/*
 * Decompiled with CFR 0.152.
 */
package net.model3.imaging;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import net.model3.imaging.ImageUtils;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class Size
implements Comparable {
    private static final Logger logger = LoggerHelper.getLogger(Size.class);
    int width_;
    int height_;

    Size() {
    }

    public Size(Component component) {
        this.width_ = component.getWidth();
        this.height_ = component.getHeight();
    }

    public Size(Image image) {
        this.width_ = image.getWidth(null);
        this.height_ = image.getHeight(null);
    }

    public Size(RenderedImage renderedImage) {
        this.width_ = renderedImage.getWidth();
        this.height_ = renderedImage.getHeight();
    }

    public Size(Dimension dimension) {
        this.width_ = dimension.width;
        this.height_ = dimension.height;
    }

    public Size(BufferedImage bufferedImage) {
        this.width_ = bufferedImage.getWidth();
        this.height_ = bufferedImage.getHeight();
    }

    public Size(int n, int n2) {
        this.set(n, n2);
    }

    public double calculateScale(Size size) {
        Size size2 = this;
        double d = (double)size2.height_ / (double)size.height_;
        double d2 = (double)size2.width_ / (double)size.width_;
        double d3 = (d + d2) / 2.0;
        Size size3 = new Size(ImageUtils.scaleValue(size.width_, d3), ImageUtils.scaleValue(size.height_, d3));
        if (!size3.equals(this)) {
            logger.warn((Object)("error in scaling  scaleWidth=" + d2 + "  scaleHeight=" + d + "  scale=" + d3 + "  this" + size2 + "  original" + size + "  calculated=" + size3), (Object)new Throwable());
        }
        return d3;
    }

    public Size createScaled(double d) {
        Size size = new Size();
        size.width_ = ImageUtils.scaleValue(this.width_, d);
        size.height_ = ImageUtils.scaleValue(this.height_, d);
        return size;
    }

    public Size createAspected(Size size, boolean bl) {
        try {
            Size size2 = new Size();
            size2.width_ = (int)((double)this.height_ * (double)size.width_ / (double)size.height_ + 0.5);
            size2.height_ = (int)((double)this.width_ * (double)size.height_ / (double)size.width_ + 0.5);
            if (size2.width_ >= this.width_) {
                if (bl) {
                    size2.set(this.width_, size2.height_);
                } else {
                    size2.set(size2.width_, this.height_);
                }
                return size2;
            }
            if (size2.height_ >= this.height_) {
                if (bl) {
                    size2.set(size2.width_, this.height_);
                } else {
                    size2.set(this.width_, size2.height_);
                }
                return size2;
            }
            if (!size2.equals(this)) {
                throw new RuntimeException("error calculating aspect ratio  this" + this + "  ratio" + size + "  aspected" + size2);
            }
            return this;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    private void set(int n, int n2) {
        this.width_ = n;
        this.height_ = n2;
    }

    public String toString() {
        return "[width=" + this.width_ + " height=" + this.height_ + "]";
    }

    public boolean equals(Object object) {
        if (object instanceof Size) {
            Size size = (Size)object;
            return size.width_ == this.width_ && size.height_ == this.height_;
        }
        if (object instanceof Image) {
            Image image = (Image)object;
            return image.getWidth(null) == this.width_ && image.getHeight(null) == this.height_;
        }
        if (object instanceof Dimension) {
            Dimension dimension = (Dimension)object;
            return dimension.width == this.width_ && dimension.height == this.height_;
        }
        if (object instanceof Dimension2D) {
            Dimension2D dimension2D = (Dimension2D)object;
            return dimension2D.getWidth() == (double)this.width_ && dimension2D.getHeight() == (double)this.height_;
        }
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            return rectangle.getWidth() == (double)this.width_ && rectangle.getHeight() == (double)this.height_;
        }
        return false;
    }

    public boolean equalsWithinPixel(Size size) {
        return Math.abs(size.width_ - this.width_) + Math.abs(size.height_ - this.height_) <= 1;
    }

    public int getHeight() {
        return this.height_;
    }

    public int getWidth() {
        return this.width_;
    }

    public String asFilename() {
        return this.width_ + "x" + this.height_;
    }

    public boolean isSameAspectRatio(Size size, int n) {
        Size size2 = this.createAspected(size, false);
        if (size2.equals(this)) {
            return true;
        }
        int n2 = Math.abs(size2.width_ - this.width_) + Math.abs(this.height_ - size2.height_);
        return n >= n2;
    }

    public boolean isSameAspectRatio(Size size) {
        Size size2 = this.createAspected(size, false);
        return size2.equals(this);
    }

    public void validateAspectRatio(Size size) {
        this.validateAspectRatio(size, true);
    }

    public void validateAspectRatio(Size size, boolean bl) {
        Size size2 = this.createAspected(size, false);
        if (size2.equalsWithinPixel(this)) {
            return;
        }
        Size size3 = this.createAspected(size, true);
        String string = "invalid aspect ratios  this" + this + "  ratio" + size + "  aspected" + size2 + "  aspected-cropped" + size3;
        if (bl) {
            throw new RuntimeException(string);
        }
        logger.warn((Object)string, (Object)new Throwable());
    }

    public double getAspectRatio() {
        return (double)this.height_ / (double)this.width_;
    }

    public boolean lessThanOrEqual(Size size) {
        if (this.width_ < size.width_) {
            return true;
        }
        if (this.width_ > size.width_) {
            return false;
        }
        return this.height_ <= size.height_;
    }

    public int hashCode() {
        return this.asFilename().hashCode();
    }

    public int compareTo(Object object) {
        Size size = (Size)object;
        if (this.equals(size)) {
            return 0;
        }
        if (this.lessThanOrEqual(size)) {
            return -1;
        }
        return 1;
    }

    public Dimension asDimension() {
        return new Dimension(this.width_, this.height_);
    }

    public Size rotate() {
        return new Size(this.height_, this.width_);
    }

    public Size scale(double d) {
        return new Size((int)(d * (double)this.width_), (int)(d * (double)this.height_));
    }
}

