/*
 * Decompiled with CFR 0.152.
 */
package net.model3.imaging;

public enum Rotation {
    NONE("", 0),
    NINETY("-90", 90),
    ONE_EIGHTY("-180", 180),
    TWO_SEVENTY("-270", -90);

    private String _suffix;
    private int _degrees;

    private Rotation(String string2, int n2) {
        this._suffix = string2;
        this._degrees = n2;
    }

    public double getRadians() {
        return Math.toRadians(this.getDegrees());
    }

    public int getDegrees() {
        return this._degrees;
    }

    public Rotation rotateClockwise() {
        return this.rotation(1);
    }

    public Rotation rotateCounterClockwise() {
        return this.rotation(-1);
    }

    Rotation rotation(int n) {
        int n2 = -1;
        for (int i = 0; i < Rotation.values().length; ++i) {
            if (Rotation.values()[i] != this) continue;
            n2 = i;
            break;
        }
        if ((n2 += n) < 0) {
            n2 += Rotation.values().length;
        } else if (n2 >= Rotation.values().length) {
            n2 -= Rotation.values().length;
        }
        return Rotation.values()[n2];
    }

    public String getSuffix() {
        return this._suffix;
    }
}

