/*
 * Decompiled with CFR 0.152.
 */
package net.model3.imaging;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import net.model3.collections.WeakValueHashMap;
import net.model3.imaging.Rotation;
import net.model3.imaging.Size;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.StopWatch;
import net.model3.logging.Level;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.File;

public class ImageUtils {
    private static final Logger logger = LoggerHelper.getLogger(ImageUtils.class);
    private static final Level STOP_WATCH_LOG_LEVEL = null;
    public static final int BI_JPEG_TYPE = 5;
    public static final int BI_PNG_TYPE = 2;
    public static final int DPI = 300;
    public static final float JPEG_HIGH_QUALITY = 1.0f;
    private static Map<Object, Object> scaleImageRenderingHints_ = new HashMap<Object, Object>();
    private static GraphicsConfiguration graphicsConfiguration_;
    private static Map<File, BufferedImage> loadedImagesCache_;

    public static void createImageFrame(Image image) {
        ImageUtils.createImageFrame(image, image, true);
    }

    public static void createImageFrame(Image image, boolean bl) {
        ImageUtils.createImageFrame(image, image, bl);
    }

    static void createImageFrame(Image image, Image image2, boolean bl) {
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().setLayout(new FlowLayout());
        ImageIcon imageIcon = new ImageIcon(image);
        JButton jButton = new JButton(imageIcon);
        jButton.setPressedIcon(new ImageIcon(image2));
        jButton.setOpaque(false);
        jButton.setBorder(null);
        jButton.setContentAreaFilled(false);
        if (image.getWidth(null) > 1000) {
            JScrollPane jScrollPane = new JScrollPane(jButton, 22, 32);
            Dimension dimension = new Dimension(800, 600);
            jScrollPane.setSize(dimension);
            jScrollPane.setPreferredSize(dimension);
            jFrame.getContentPane().add(jScrollPane);
        } else {
            jFrame.getContentPane().add(jButton);
        }
        if (bl) {
            jFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
        }
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static BufferedImage combineImages(Image image, Image image2, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(image2.getWidth(null), image2.getHeight(null), 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image2, 0, 0, null);
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.drawImage(image, n, n2, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage scaleImage(BufferedImage bufferedImage, Size size, boolean bl) {
        return ImageUtils.scaleImage(bufferedImage, size.width_, size.height_, bl);
    }

    public static BufferedImage scaleImage(BufferedImage bufferedImage, int n, int n2, boolean bl) {
        int n3 = bufferedImage.getWidth(null);
        int n4 = bufferedImage.getHeight(null);
        if (n2 <= 0 && n <= 0) {
            throw new RuntimeException("invalid sizes " + n + ", " + n2);
        }
        if (n <= 0) {
            n = n3 * n2 / n4;
        }
        if (n2 <= 0) {
            n2 = n4 * n / n3;
        }
        int n5 = bufferedImage.getType() == 0 ? 2 : bufferedImage.getType();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, n5);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.addRenderingHints(scaleImageRenderingHints_);
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        graphics2D.dispose();
        if (bl) {
            bufferedImage.flush();
        }
        return bufferedImage2;
    }

    public static BufferedImage loadImage(String string) {
        return ImageUtils.loadImage(new File(string));
    }

    public static BufferedImage loadImage(File file) {
        return ImageUtils.loadImage(file, true, false, false);
    }

    public static BufferedImage loadImage(File file, boolean bl) {
        return ImageUtils.loadImage(file, bl, true, false);
    }

    public static BufferedImage loadImage(File file, boolean bl, boolean bl2) {
        return ImageUtils.loadImage(file, bl, bl2, false);
    }

    public static BufferedImage loadImage(File file, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        if (bl2 && (object = ImageUtils.getImageFromCache(file)) != null) {
            logger.trace((Object)("using cached image for " + file.getCanonicalPath()));
            return object;
        }
        ImageUtils.exists(file);
        object = new StopWatch("loading image " + file.getCanonicalPath(), STOP_WATCH_LOG_LEVEL);
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(file.asCanonicalFile());
        }
        catch (Exception exception) {
            logger.error((Object)("error loading image " + file.getCanonicalPath()), (Object)exception);
        }
        if (bufferedImage == null) {
            if (bl) {
                throw new RuntimeException(file.getCanonicalPath() + " is not an image file.");
            }
            return null;
        }
        ((StopWatch)object).stop();
        if (bl2) {
            ImageUtils.addImageToCache(file, bufferedImage);
        }
        return bufferedImage;
    }

    public static BufferedImage cropImage(Image image, Rectangle rectangle) {
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, rectangle.width - 1, rectangle.height - 1, rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Rectangle getHorizontalImageBounds(BufferedImage bufferedImage) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = bufferedImage.getWidth();
        int n6 = bufferedImage.getHeight();
        int n7 = 0;
        block0: for (n4 = 0; n4 < n5; ++n4) {
            n7 = n4;
            for (n3 = 0; n3 < n6; ++n3) {
                n2 = bufferedImage.getRGB(n4, n3);
                n = n2 >> 24 & 0xFF;
                if (n != 0) break block0;
            }
        }
        n4 = n5;
        if (n7 + 1 == n5) {
            n4 = n5;
        } else {
            block2: for (n3 = n5 - 1; n3 > n7; --n3) {
                n4 = n3;
                for (n2 = 0; n2 < n6; ++n2) {
                    n = bufferedImage.getRGB(n3, n2);
                    int n8 = n >> 24 & 0xFF;
                    if (n8 != 0) break block2;
                }
            }
        }
        return new Rectangle(n7, 0, n4 - n7 + 1, bufferedImage.getHeight());
    }

    public static void saveImageAsPng(BufferedImage bufferedImage, String string) {
        try {
            StopWatch stopWatch = new StopWatch("saving image " + string, STOP_WATCH_LOG_LEVEL);
            File file = new File(string);
            file.getParent().makeDirectories();
            boolean bl = ImageIO.write((RenderedImage)bufferedImage, "png", file.asFile());
            if (!bl) {
                throw new RuntimeException("error writing " + string);
            }
            stopWatch.stop();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public static void saveImageAsJpeg(BufferedImage bufferedImage, String string) {
        ImageUtils.saveImageAsJpeg(bufferedImage, string, 1.0f);
    }

    public static void saveImageAsJpeg(BufferedImage bufferedImage, String string, float f) {
        try {
            StopWatch stopWatch = new StopWatch("saving image " + string, STOP_WATCH_LOG_LEVEL);
            File file = new File(string);
            ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("jpeg").next();
            JPEGImageWriteParam jPEGImageWriteParam = new JPEGImageWriteParam(Locale.getDefault());
            jPEGImageWriteParam.setCompressionMode(2);
            jPEGImageWriteParam.setCompressionQuality(f);
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file.asFile());
            imageWriter.setOutput(imageOutputStream);
            IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
            imageWriter.write(null, iIOImage, jPEGImageWriteParam);
            imageOutputStream.flush();
            imageWriter.dispose();
            imageOutputStream.close();
            stopWatch.stop();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public static void saveImageAsJpeg(BufferedImage bufferedImage, OutputStream outputStream, float f) {
        try {
            if (bufferedImage.getType() != 5) {
                throw new RuntimeException("not a jpeg image type");
            }
            StopWatch stopWatch = new StopWatch("writing jpeg to stream " + bufferedImage.toString(), STOP_WATCH_LOG_LEVEL);
            ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("jpeg").next();
            JPEGImageWriteParam jPEGImageWriteParam = new JPEGImageWriteParam(Locale.getDefault());
            jPEGImageWriteParam.setCompressionMode(2);
            jPEGImageWriteParam.setCompressionQuality(f);
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
            imageWriter.setOutput(imageOutputStream);
            IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
            imageWriter.write(null, iIOImage, jPEGImageWriteParam);
            imageWriter.dispose();
            imageOutputStream.close();
            stopWatch.stop();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    static void exists(File file) {
        if (!file.exists()) {
            throw new RuntimeException("file " + file.getCanonicalPath() + " not found.");
        }
    }

    static void forceGarbageCollection() {
        long l = Runtime.getRuntime().freeMemory();
        long l2 = -1L;
        while (true) {
            long l3 = l2;
            l2 = Runtime.getRuntime().freeMemory();
            if (l2 == l3) break;
            System.gc();
        }
        logger.debug((Object)("freed:" + (l2 - l) + "  used:" + (Runtime.getRuntime().totalMemory() - l2) + "  total:" + Runtime.getRuntime().totalMemory()));
    }

    public static BufferedImage createRotatedImage(Image image) {
        return ImageUtils.createRotatedImage(image, false);
    }

    public static BufferedImage createRotatedImage(Image image, boolean bl) {
        Rotation rotation = bl ? Rotation.NINETY : Rotation.TWO_SEVENTY;
        return ImageUtils.createRotatedImage(image, rotation);
    }

    public static BufferedImage createRotatedImage(Image image, Rotation rotation) {
        int n;
        int n2;
        if (rotation == Rotation.NONE) {
            return (BufferedImage)image;
        }
        int n3 = image.getHeight(null);
        int n4 = image.getWidth(null);
        if (rotation == Rotation.NINETY || rotation == Rotation.TWO_SEVENTY) {
            n2 = n4;
            n = n3;
        } else {
            n2 = n3;
            n = n4;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (rotation == Rotation.NINETY) {
            graphics2D.rotate(rotation.getRadians(), n3 / 2, n3 / 2);
        } else if (rotation == Rotation.ONE_EIGHTY) {
            graphics2D.rotate(rotation.getRadians(), n4 / 2, n3 / 2);
        } else if (rotation == Rotation.TWO_SEVENTY) {
            graphics2D.rotate(rotation.getRadians(), n4 / 2, n4 / 2);
        }
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static int scaleValue(int n, double d) {
        return (int)(d * (double)n + 0.5);
    }

    public static Rectangle scale(Rectangle rectangle, double d) {
        int n = ImageUtils.scaleValue(rectangle.x, d);
        int n2 = ImageUtils.scaleValue(rectangle.y, d);
        int n3 = ImageUtils.scaleValue(rectangle.height, d);
        int n4 = ImageUtils.scaleValue(rectangle.width, d);
        return new Rectangle(n, n2, n4, n3);
    }

    private static BufferedImage getImageFromCache(File file) {
        return loadedImagesCache_.get(file);
    }

    private static void addImageToCache(File file, BufferedImage bufferedImage) {
        loadedImagesCache_.put(file, bufferedImage);
    }

    public static int inchesToPixels(double d) {
        return (int)(d * 300.0 + 0.5);
    }

    public static BufferedImage createScaledImage(BufferedImage bufferedImage, Size size, boolean bl, boolean bl2, boolean bl3) {
        Size size2 = new Size(bufferedImage);
        if (bl3) {
            size = size.createAspected(size2, true);
        }
        BufferedImage bufferedImage2 = bl2 ? ImageUtils.createTransparentImage(size) : ImageUtils.createOpaqueImage(size);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.addRenderingHints(scaleImageRenderingHints_);
        graphics2D.drawImage(bufferedImage, 0, 0, size.getWidth(), size.getHeight(), null);
        graphics2D.dispose();
        if (bl) {
            bufferedImage.flush();
        }
        return bufferedImage2;
    }

    public static BufferedImage createTransparentImage(Size size) {
        return ImageUtils.getGraphicsConfiguration().createCompatibleImage(size.getWidth(), size.getHeight(), 2);
    }

    public static BufferedImage createOpaqueImage(Size size) {
        return ImageUtils.getGraphicsConfiguration().createCompatibleImage(size.getWidth(), size.getHeight(), 1);
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        if (graphicsConfiguration_ == null) {
            graphicsConfiguration_ = ImageUtils.findGraphicsConfiguration();
        }
        return graphicsConfiguration_;
    }

    private static GraphicsConfiguration findGraphicsConfiguration() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        if (graphicsDeviceArray.length > 0) {
            return graphicsDeviceArray[0].getDefaultConfiguration();
        }
        return null;
    }

    public static BufferedImage toDeviceCompatibleBufferedImage(Image image) {
        Size size = new Size(image);
        BufferedImage bufferedImage = ImageUtils.createOpaqueImage(new Size(image));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, size.getWidth(), size.getHeight(), null);
        graphics2D.dispose();
        return bufferedImage;
    }

    static {
        loadedImagesCache_ = Collections.synchronizedMap(new WeakValueHashMap());
        scaleImageRenderingHints_.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }
}

