/*
 * Decompiled with CFR 0.152.
 */
package net.model3.imaging;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import net.model3.guice.bootstrap.CacheDirectory;
import net.model3.imaging.ImageProxy;
import net.model3.imaging.ImageProxyListener;
import net.model3.lang.Visitor;
import net.model3.newfile.Directory;
import net.model3.swing.EventManager;

@Singleton
public class ImageProxyContainer {
    Directory _cacheDirectory;
    EventManager<ImageProxyListener> _eventManager = EventManager.create();

    public ImageProxyContainer() {
    }

    @Inject
    public ImageProxyContainer(CacheDirectory cacheDirectory) {
        this._cacheDirectory = new Directory((Directory)cacheDirectory.get(), "document-thumbnails");
    }

    public Directory getCacheDirectory() {
        return this._cacheDirectory;
    }

    public void setCacheDirectory(Directory directory) {
        this._cacheDirectory = directory;
    }

    public EventManager<ImageProxyListener> getEventManager() {
        return this._eventManager;
    }

    public void fireImageChanged(final ImageProxy<?> imageProxy) {
        this._eventManager.safeDispatch(new Visitor<ImageProxyListener>(){

            @Override
            public void visit(ImageProxyListener imageProxyListener) {
                imageProxyListener.imageChanged(imageProxy);
            }
        });
    }

    public void fullSizeViewEvent(ImageProxy<?> imageProxy) {
    }
}

