/*
 * Decompiled with CFR 0.152.
 */
package net.model3.imaging;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import net.model3.guice.ImmutableValue;
import net.model3.guice.ReadableValue;
import net.model3.imaging.ImageProxy;
import net.model3.imaging.ImageProxyContainer;
import net.model3.imaging.ImageUtils;
import net.model3.imaging.Rotation;
import net.model3.imaging.Size;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.File;

public abstract class AbstractImageProxy<T>
implements ImageProxy<T> {
    private static final Logger logger = LoggerHelper.getLogger();
    private URL _imageLocationAsURL;
    private File _imageLocationAsFile;
    private Size _imageSize;
    private String _title;
    private String _caption;
    private String _uuid;
    private String _qualifiedName;
    private boolean _keepImageInMemory = false;
    private boolean _cacheFullSizeImage = true;
    private Rotation _rotation = Rotation.NONE;
    private ReadableValue<BufferedImage> _image;
    ImageProxyContainer _imageImageProxyContainer;

    public void setImageLocation(URL uRL) {
        this._imageLocationAsURL = uRL;
    }

    public void setImageLocation(File file) {
        this._imageLocationAsFile = file;
    }

    protected void setImageSize(Size size) {
        this._imageSize = size;
    }

    @Override
    public Size getImageSize() {
        if (this._imageSize == null) {
            this._imageSize = new Size(this.getImage());
        }
        return this._imageSize;
    }

    public File getImageLocationAsFile() {
        return this._imageLocationAsFile;
    }

    public BufferedImage loadImage() {
        try {
            File file = this.getImageLocationAsFile();
            if (file != null) {
                logger.trace((Object)"loading image {}", (Object)file.getCanonicalPath());
                return this.loadImage(file);
            }
            logger.trace((Object)"loading image {}", (Object)this._imageLocationAsURL);
            return this.loadImage(this._imageLocationAsURL);
        }
        catch (Exception exception) {
            logger.error((Object)exception);
            throw new RuntimeException(exception);
        }
    }

    @Override
    public BufferedImage getImage() {
        BufferedImage bufferedImage = null;
        if (this._image != null) {
            bufferedImage = this._image.get();
        }
        if (bufferedImage == null) {
            bufferedImage = this.loadImage();
            if (bufferedImage == null) {
                bufferedImage = this.loadImage();
                throw new RuntimeException("unable to load image loadImage() returned null for " + this.getUuid());
            }
            if (this._cacheFullSizeImage) {
                if (this._keepImageInMemory) {
                    this._image = new ImmutableValue<BufferedImage>(bufferedImage);
                } else {
                    final WeakReference<BufferedImage> weakReference = new WeakReference<BufferedImage>(bufferedImage);
                    this._image = new ReadableValue<BufferedImage>(){

                        @Override
                        public BufferedImage get() {
                            return (BufferedImage)weakReference.get();
                        }
                    };
                }
            }
        }
        return bufferedImage;
    }

    @Override
    public BufferedImage getImage(Size size) {
        return this.getImage(size, Rotation.NONE);
    }

    @Override
    public BufferedImage getImage(Size size, Rotation rotation) {
        Object object;
        BufferedImage bufferedImage;
        logger.trace((Object)"getting image {} size {} rotation {}", (Object)this.getUuid(), (Object)size, (Object)rotation);
        if (size == null) {
            bufferedImage = this.getImage();
        } else {
            object = this.getCachedFile(size);
            if (!((File)object).exists()) {
                logger.trace((Object)"scaling original image thumbnail doesn't exist");
                BufferedImage bufferedImage2 = this.getImage();
                BufferedImage bufferedImage3 = ImageUtils.createScaledImage(bufferedImage2, size, true, false, this.getPreserveAspectRatio());
                this.writeThumbnail(size, (File)object, bufferedImage3);
                bufferedImage = bufferedImage3;
            } else {
                logger.trace((Object)"loading thumbnail");
                bufferedImage = this.loadImage((File)object);
            }
        }
        if (rotation != null && rotation != Rotation.NONE) {
            logger.trace((Object)"rotating image");
            object = bufferedImage;
            bufferedImage = ImageUtils.createRotatedImage((Image)object, rotation);
        }
        logger.trace((Object)"completed getting image {} size {} rotation {}", (Object)this.getUuid(), (Object)size, (Object)rotation);
        return bufferedImage;
    }

    protected InputStream wrapInputStream(InputStream inputStream) {
        return inputStream;
    }

    protected BufferedImage loadImage(File file) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = file.createInputStream();
            BufferedImage bufferedImage = ImageIO.read(this.wrapInputStream(fileInputStream));
            return bufferedImage;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (Exception exception) {}
        }
    }

    protected BufferedImage loadImage(URL uRL) {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            BufferedImage bufferedImage = ImageIO.read(this.wrapInputStream(inputStream));
            return bufferedImage;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    protected OutputStream wrapOutputStream(OutputStream outputStream) {
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveImage(BufferedImage bufferedImage, File file) throws Exception {
        OutputStream outputStream = null;
        try {
            file.getParent().makeDirectories();
            outputStream = this.wrapOutputStream(file.createOutputStream());
            ImageIO.write((RenderedImage)bufferedImage, this.getImageIoFormatName(), outputStream);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void writeThumbnail(Size size, File file, BufferedImage bufferedImage) {
        try {
            this.saveImage(bufferedImage, file);
        }
        catch (Exception exception) {
            logger.warn((Object)"error creating thumbnail {} for {}", (Object)size, (Object)this.getQualifiedName(), (Object)exception);
        }
    }

    protected String getFileExtension() {
        return "jpeg";
    }

    protected String getImageIoFormatName() {
        return "jpeg";
    }

    protected File getCachedFile(Size size) {
        return new File(this.getImageProxyContainer().getCacheDirectory(), this.getUuid() + "-" + (Object)((Object)this.getRotation()) + "-" + size + "." + this.getFileExtension());
    }

    @Override
    public String getUuid() {
        return this._uuid;
    }

    public void setUuid(String string) {
        this._uuid = string;
    }

    @Override
    public String getQualifiedName() {
        if (this._qualifiedName == null) {
            this._qualifiedName = this.getUuid();
        }
        return this._qualifiedName;
    }

    public void setQualifiedName(String string) {
        this._qualifiedName = string;
    }

    public String getFrameTitle() {
        if (this._title == null) {
            return this.getUuid();
        }
        return this._title;
    }

    public void setTitle(String string) {
        this._title = string;
    }

    public String getThumbnailCaption() {
        if (this._caption == null) {
            this.setCaption(this.getFrameTitle());
        }
        return this._caption;
    }

    public void setCaption(String string) {
        this._caption = string;
    }

    @Override
    public Rotation getRotation() {
        return this._rotation;
    }

    @Override
    public void setRotation(Rotation rotation) {
        this._rotation = rotation;
    }

    public void setKeepImageInMemory(boolean bl) {
        this._keepImageInMemory = bl;
    }

    public void setCacheFullSizeImage(boolean bl) {
        this._cacheFullSizeImage = bl;
    }

    @Override
    public ImageProxyContainer getImageProxyContainer() {
        return this._imageImageProxyContainer;
    }

    public void setImageImageProxyContainer(ImageProxyContainer imageProxyContainer) {
        this._imageImageProxyContainer = imageProxyContainer;
    }

    public void notifyListeners() {
        this.getImageProxyContainer().fireImageChanged(this);
    }

    protected void executeOffTheEDT(Runnable runnable) {
        if (!SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        }
    }

    @Override
    public abstract T getDelegate();

    @Override
    public abstract boolean getPreserveAspectRatio();
}

