/*
 * Decompiled with CFR 0.152.
 */
package net.model3.guice.bootstrap;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Map;
import net.model3.guice.PropertySource;
import net.model3.guice.bootstrap.ApplicationName;
import net.model3.lang.ClassX;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.util.ProcessManagerHelper;

public class ProviderApplicationName
implements Provider<ApplicationName> {
    Logger logger = LoggerHelper.getLogger();
    @Inject
    PropertySource _propertySource;

    public ApplicationName get() {
        String string = this.resolveApplicationName();
        if (string == null) {
            throw new RuntimeException("property app.name not found");
        }
        return new ApplicationName(string);
    }

    public String resolveApplicationName() {
        String string = this._propertySource.get("app.name");
        if (string == null) {
            string = ProcessManagerHelper.getAppName();
            if (StringX.isNotBlank(ProcessManagerHelper.getAppSuffix())) {
                string = string + "-" + ProcessManagerHelper.getAppSuffix();
            }
        }
        if (string == null) {
            string = this.getMainClass();
        }
        return string;
    }

    public String getMainClass() {
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        for (Thread thread : map.keySet()) {
            if (!thread.getName().equals("main")) continue;
            return ClassX.getShortName(map.get(thread)[0].getClassName());
        }
        this.logger.warn((Object)"no main thread found to initialize the application name from main class.  best to explicitly supply an app.name via the servlet context or system properties");
        return null;
    }
}

