/*
 * Decompiled with CFR 0.152.
 */
package net.model3.guice;

import com.google.inject.Provider;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

public class ProviderScheduledExecutor
implements Provider<ScheduledExecutorService> {
    int _corePoolSize;

    public ProviderScheduledExecutor(int n) {
        this._corePoolSize = n;
    }

    public ProviderScheduledExecutor() {
        this(4);
    }

    public ScheduledExecutorService get() {
        return Executors.newScheduledThreadPool(this._corePoolSize, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName("scheduled-" + thread.getId());
                thread.setDaemon(true);
                return thread;
            }
        });
    }
}

