/*
 * Decompiled with CFR 0.152.
 */
package net.model3.guice;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import net.model3.guice.DatabaseConfig;
import net.model3.lang.ClassX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.sf.log4jdbc.DriverSpy;

public class ProviderDataSource
implements Provider<DataSource> {
    private static final Log logger = LogHelper.getLog();
    private DatabaseConfig _databaseConfig;

    public ProviderDataSource() {
    }

    @Inject
    public ProviderDataSource(DatabaseConfig databaseConfig) {
        this._databaseConfig = databaseConfig;
    }

    public DataSource get() {
        System.setProperty("log4jdbc.no_line_breaks", "true");
        try {
            ClassX.load(this._databaseConfig.getDriver());
        }
        catch (Exception exception) {
            logger.warn((Object)"errors loading postgres jdbc drivers", (Object)exception);
        }
        try {
            DriverManager.registerDriver((Driver)new DriverSpy());
        }
        catch (Exception exception) {
            logger.warn((Object)"errors loading log4jdbc jdbc drivers", (Object)exception);
        }
        try {
            DataSource dataSource = this._databaseConfig.createDataSource();
            return new DataSourceWrapper(dataSource);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static class DataSourceWrapper
    implements DataSource {
        private DataSource _delegate;

        private DataSourceWrapper(DataSource dataSource) {
            this._delegate = dataSource;
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return this._delegate.getParentLogger();
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this._delegate.getConnection();
        }

        @Override
        public Connection getConnection(String string, String string2) throws SQLException {
            return this._delegate.getConnection(string, string2);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this._delegate.getLoginTimeout();
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this._delegate.getLogWriter();
        }

        @Override
        public boolean isWrapperFor(Class<?> clazz) throws SQLException {
            return this._delegate.getClass().equals(clazz);
        }

        @Override
        public void setLoginTimeout(int n) throws SQLException {
            this._delegate.setLoginTimeout(n);
        }

        @Override
        public void setLogWriter(PrintWriter printWriter) throws SQLException {
            this._delegate.setLogWriter(printWriter);
        }

        @Override
        public <T> T unwrap(Class<T> clazz) throws SQLException {
            return (T)this._delegate;
        }

        public void setDelegate(DataSource dataSource) {
            this._delegate = dataSource;
        }
    }
}

