/*
 * Decompiled with CFR 0.152.
 */
package net.model3.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.util.concurrent.ScheduledExecutorService;
import net.model3.bean.ConverterFactory;
import net.model3.bean.converters.Converter;
import net.model3.guice.Injected;
import net.model3.guice.InjectionCompletedListener;
import net.model3.guice.LifeCycleListeners;
import net.model3.guice.LifeCycleManager;
import net.model3.guice.PropertySource;
import net.model3.guice.ProviderConverterFactory;
import net.model3.guice.ProviderScheduledExecutor;
import net.model3.guice.bootstrap.ApplicationName;
import net.model3.guice.bootstrap.CacheDirectory;
import net.model3.guice.bootstrap.ConfigurationDirectory;
import net.model3.guice.bootstrap.InProduction;
import net.model3.guice.bootstrap.LogDirectory;
import net.model3.guice.bootstrap.ProviderApplicationName;
import net.model3.guice.bootstrap.ProviderCacheDirectory;
import net.model3.guice.bootstrap.ProviderConfigDirectory;
import net.model3.guice.bootstrap.ProviderLogDirectory;
import net.model3.guice.standalone.SystemPropertySource;
import net.model3.lang.ExceptionPropagator;
import net.model3.transaction.ProviderTransaction;
import net.model3.transaction.ProviderTransactionInternal;
import net.model3.transaction.Transaction;
import net.model3.transaction.TransactionInternal;
import net.model3.transaction.TxnScoped;

public class M3GuiceModule
extends AbstractModule {
    LifeCycleManager _lifeCycleManager = new LifeCycleManager();

    protected void configure() {
        this.bindScope(TxnScoped.class, Transaction.Scope);
        this.bindLifeCycleListener();
        this.bind(LifeCycleManager.class).toInstance((Object)this._lifeCycleManager);
        this.bind(ConfigurationDirectory.class).toProvider(ProviderConfigDirectory.class).in(Scopes.SINGLETON);
        this.bind(LogDirectory.class).toProvider(ProviderLogDirectory.class).in(Scopes.SINGLETON);
        Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), Converter.class);
        this.bind(ConverterFactory.class).toProvider(ProviderConverterFactory.class).in(Scopes.SINGLETON);
        this.bind(Transaction.class).toProvider(ProviderTransaction.class);
        this.bind(TransactionInternal.class).toProvider(ProviderTransactionInternal.class);
        this.bind(ApplicationName.class).toProvider(ProviderApplicationName.class).in(Scopes.SINGLETON);
        this.bind(ScheduledExecutorService.class).toProvider(ProviderScheduledExecutor.class).in(Scopes.SINGLETON);
        this.bind(PropertySource.class).to(SystemPropertySource.class).in(Scopes.SINGLETON);
        this.bind(Boolean.class).annotatedWith(InProduction.class).toInstance((Object)false);
        this.bind(CacheDirectory.class).toProvider(ProviderCacheDirectory.class).in(Scopes.SINGLETON);
    }

    protected void bindLifeCycleListener() {
        this.bindListener(Matchers.any(), new TypeListener(){

            public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
                typeEncounter.register(new InjectionListener<I>(){

                    public void afterInjection(I i) {
                        if (i instanceof InjectionCompletedListener) {
                            try {
                                ((InjectionCompletedListener)i).injectionComplete();
                            }
                            catch (Exception exception) {
                                throw ExceptionPropagator.wrap(exception);
                            }
                        }
                        if (i instanceof LifeCycleListeners.LifeCycleListener) {
                            M3GuiceModule.this._lifeCycleManager.register((LifeCycleListeners.LifeCycleListener)i);
                        }
                    }
                });
            }
        });
        this.bindListener(Matchers.any(), new TypeListener(){

            public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
                typeEncounter.register(new InjectionListener<I>(){

                    public void afterInjection(I i) {
                        if (i instanceof Injected) {
                            ((Injected)i).injectionCompleted();
                        }
                    }
                });
            }
        });
    }
}

