/*
 * Decompiled with CFR 0.152.
 */
package net.model3.guice;

import com.google.inject.Singleton;
import java.util.List;
import net.model3.collections.ListX;
import net.model3.guice.LifeCycleListeners;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

@Singleton
public class LifeCycleManager {
    final Logger _logger = LoggerHelper.getLogger();
    public final ListenerManager<LifeCycleListeners.Bootstrap> bootstrap = new ListenerManager<LifeCycleListeners.Bootstrap>(){

        @Override
        String name() {
            return "bootstrap";
        }

        @Override
        void notifyListenerImpl(LifeCycleListeners.Bootstrap bootstrap) throws Exception {
            bootstrap.postBootstrap();
        }
    };
    public final ListenerManager<LifeCycleListeners.Config> config = new ListenerManager<LifeCycleListeners.Config>(){

        @Override
        String name() {
            return "config";
        }

        @Override
        void notifyListenerImpl(LifeCycleListeners.Config config) throws Exception {
            config.configComplete();
        }
    };
    public final ListenerManager<LifeCycleListeners.Destroy> destroy = new ListenerManager<LifeCycleListeners.Destroy>(){

        @Override
        String name() {
            return "destroy";
        }

        @Override
        void notifyListenerImpl(LifeCycleListeners.Destroy destroy) throws Exception {
            destroy.preDestroy();
        }
    };

    public void register(LifeCycleListeners.LifeCycleListener lifeCycleListener) {
        if (lifeCycleListener instanceof LifeCycleListeners.Bootstrap) {
            this.bootstrap.add((LifeCycleListeners.Bootstrap)lifeCycleListener);
        }
        if (lifeCycleListener instanceof LifeCycleListeners.Config) {
            this.config.add((LifeCycleListeners.Config)lifeCycleListener);
        }
        if (lifeCycleListener instanceof LifeCycleListeners.Destroy) {
            this.destroy.add((LifeCycleListeners.Destroy)lifeCycleListener);
        }
    }

    public abstract class ListenerManager<T> {
        List<T> _listeners = ListX.create();
        Throwable _fired;

        public synchronized void add(T t) {
            if (this._listeners == null) {
                this.notifyListener(t);
            } else {
                this._listeners.add(t);
            }
        }

        public synchronized void fire() {
            if (this._listeners == null) {
                LifeCycleManager.this._logger.warn((Object)(this.name() + " fire previosuly called"), (Object)this._fired);
                LifeCycleManager.this._logger.warn((Object)(this.name() + " fire this call"), (Object)new Throwable());
            } else {
                LifeCycleManager.this._logger.debug((Object)("firing " + this.name()));
                this._fired = new Throwable();
                for (T t : ListX.create(this._listeners)) {
                    this.notifyListener(t);
                }
                this._listeners = null;
            }
        }

        abstract String name();

        abstract void notifyListenerImpl(T var1) throws Exception;

        void notifyListener(T t) {
            try {
                this.notifyListenerImpl(t);
            }
            catch (Exception exception) {
                LoggerHelper.getLogger().warn((Object)"swallowed", (Object)exception);
            }
        }
    }
}

