/*
 * Decompiled with CFR 0.152.
 */
package net.model3.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import java.net.URL;
import java.util.List;
import net.model3.collections.ListX;
import net.model3.guice.LifeCycleManager;
import net.model3.guice.M3GuiceModule;
import net.model3.guice.bootstrap.Bootstrapper;
import net.model3.io.IOHelper;
import net.model3.lang.ClassX;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.StringX;
import net.model3.logging.LogCapturingTransaction;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

@Singleton
public class DependencyInjector {
    private static DependencyInjector _instance;
    Logger logger = LoggerHelper.getLogger();
    Injector _injector;

    public static <T> T inject(T t) {
        DependencyInjector.get().injectMembers(t);
        return t;
    }

    public static void set(Module ... moduleArray) {
        DependencyInjector.getDependencyInjectorInstance().set(Guice.createInjector((Module[])moduleArray));
    }

    public static DependencyInjector getDependencyInjectorInstance() {
        if (_instance == null) {
            _instance = new DependencyInjector();
        }
        return _instance;
    }

    public static void reset() {
        _instance = null;
    }

    public static Injector get(boolean bl) {
        return DependencyInjector.getDependencyInjectorInstance().getInjector(bl);
    }

    public static Injector get() {
        return DependencyInjector.get(true);
    }

    public void set(Injector injector) {
        this._injector = injector;
    }

    public static <T> T getInstance(Class<T> clazz) {
        return (T)DependencyInjector.get().getInstance(clazz);
    }

    protected Injector getInjector(boolean bl) {
        if (this._injector == null && bl) {
            this.doBootstrapping();
        }
        return this._injector;
    }

    private void doBootstrapping() {
        LogCapturingTransaction logCapturingTransaction = new LogCapturingTransaction(){

            @Override
            protected void runImpl() throws Exception {
                try {
                    DependencyInjector.this._injector = DependencyInjector.this.createInjector(Stage.DEVELOPMENT);
                    Bootstrapper bootstrapper = (Bootstrapper)DependencyInjector.this._injector.getInstance(Bootstrapper.class);
                    bootstrapper.bootstrap();
                }
                catch (Exception exception) {
                    DependencyInjector.this.logger.fatal((Object)"fatal error while bootstrapping", (Object)exception);
                    ExceptionPropagator.throwUnchecked(exception);
                }
            }
        };
        try {
            logCapturingTransaction.run();
            this.logger.log(logCapturingTransaction.getMostSevereLevel(), "messages from the bootstrap process\n" + StringX.indent("        ", logCapturingTransaction.getEventsAsString()));
        }
        catch (Exception exception) {
            System.err.println(logCapturingTransaction.getEventsAsString());
            exception.printStackTrace();
            ExceptionPropagator.throwUnchecked(exception);
        }
        ((LifeCycleManager)this._injector.getInstance(LifeCycleManager.class)).bootstrap.fire();
    }

    protected Injector createInjector(Stage stage) {
        List<ModuleDefinition> list = ListX.create();
        this.loadModulesInFile(list, "guice-modules.list");
        if (DependencyInjector.isWebapp()) {
            this.loadModulesInFile(list, "guice-modules-webapp.list");
        } else {
            this.loadModulesInFile(list, "guice-modules-standalone.list");
        }
        List list2 = ListX.create();
        if (list.isEmpty()) {
            list2.add(new M3GuiceModule());
        } else {
            int n = Integer.MIN_VALUE;
            for (ModuleDefinition moduleDefinition : list) {
                n = Math.max(n, moduleDefinition._sequence);
            }
            for (ModuleDefinition moduleDefinition : list) {
                if (moduleDefinition._sequence != n) continue;
                list2.add(moduleDefinition.create());
            }
        }
        if (stage != null) {
            stage = Stage.DEVELOPMENT;
        }
        return Guice.createInjector((Stage)stage, list2);
    }

    protected void loadModulesInFile(List<ModuleDefinition> list, String string) {
        for (URL uRL : ClassX.getResources(string)) {
            try {
                this.logger.debug((Object)"loadModulesInFile() url = {}", (Object)uRL);
                for (String string2 : IOHelper.readLines(uRL.openStream())) {
                    if (StringX.isBlank(string2 = string2.trim())) continue;
                    this.logger.debug((Object)"loadModulesInFile() line = {}", (Object)string2);
                    try {
                        ModuleDefinition moduleDefinition = new ModuleDefinition();
                        moduleDefinition._line = string2;
                        moduleDefinition._url = uRL;
                        String[] stringArray = string2.split(" ");
                        if (stringArray.length == 1) {
                            moduleDefinition._sequence = 0;
                            moduleDefinition._moduleClass = ClassX.load(stringArray[0]);
                        } else {
                            moduleDefinition._sequence = Integer.parseInt(stringArray[0]);
                            moduleDefinition._moduleClass = ClassX.load(stringArray[1]);
                        }
                        list.add(moduleDefinition);
                    }
                    catch (Exception exception) {
                        this.logger.warn((Object)"error loading guice module {}", (Object)string2, (Object)exception);
                    }
                }
            }
            catch (Exception exception) {
                this.logger.warn((Object)"error openning {}", (Object)uRL, (Object)exception);
            }
        }
    }

    public static boolean isWebapp() {
        String[] stringArray = new String[]{"org.mortbay.jetty", "org.apache.tomcat", "org.apache.coyote", "org.apache.catalina", "net.model3.servlet.runner.JettyRunner"};
        for (StackTraceElement stackTraceElement : new Throwable().getStackTrace()) {
            for (String string : stringArray) {
                if (!stackTraceElement.getClassName().startsWith(string)) continue;
                return true;
            }
        }
        return false;
    }

    class ModuleDefinition {
        URL _url;
        String _line;
        int _sequence;
        Class<? extends Module> _moduleClass;

        ModuleDefinition() {
        }

        Module create() {
            Module module = null;
            Object t = ClassX.newInstance(this._moduleClass);
            if (t instanceof Provider) {
                module = (Module)((Provider)t).get();
            } else if (t instanceof Module) {
                module = (Module)t;
            } else {
                DependencyInjector.this.logger.warn((Object)"don't know how to handle module {} it is neither implements Provider<Module> or Module", (Object)this._line);
            }
            if (module != null) {
                DependencyInjector.this.logger.debug((Object)"module {} from {} added", (Object)this._line, (Object)this._url);
            }
            return module;
        }
    }
}

