/*
 * Decompiled with CFR 0.152.
 */
package net.model3.guice;

import java.util.Properties;
import net.model3.lang.StringX;
import net.model3.lang.TimeDuration;

public class DatabasePoolConfig {
    private int maxActive = 20;
    private boolean testWhileIdle = true;
    private boolean testOnReturn = true;
    private boolean testOnBorrow = true;
    private TimeDuration timeBetweenEvictionRunsMillis = new TimeDuration("10 minutes");
    private boolean poolPreparedStatements = true;
    private boolean defaultAutoCommit = true;
    private int initialSize = 1;
    private TimeDuration maxWait = new TimeDuration("3 seconds");
    private String validationQuery = "";
    private boolean logAbandoned = false;
    private boolean removeAbandoned = false;
    private TimeDuration removeAbandonedTimeout = new TimeDuration("30 minutes");

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int n) {
        this.maxActive = n;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public void setTestWhileIdle(boolean bl) {
        this.testWhileIdle = bl;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public void setTestOnReturn(boolean bl) {
        this.testOnReturn = bl;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(boolean bl) {
        this.testOnBorrow = bl;
    }

    public TimeDuration getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(TimeDuration timeDuration) {
        this.timeBetweenEvictionRunsMillis = timeDuration;
    }

    public boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public void setPoolPreparedStatements(boolean bl) {
        this.poolPreparedStatements = bl;
    }

    public boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean bl) {
        this.defaultAutoCommit = bl;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int n) {
        this.initialSize = n;
    }

    public TimeDuration getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(TimeDuration timeDuration) {
        this.maxWait = timeDuration;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String string) {
        this.validationQuery = string;
    }

    public Properties asDbcpProperties() {
        Properties properties = new Properties();
        properties.put("maxActive", "" + this.maxActive);
        properties.put("testWhileIdle", "" + this.testWhileIdle);
        properties.put("testOnReturn", "" + this.testOnReturn);
        properties.put("testOnBorrow", "" + this.testOnBorrow);
        properties.put("timeBetweenEvictionRunsMillis", "" + this.timeBetweenEvictionRunsMillis.inMilliseconds());
        properties.put("poolPreparedStatements", "" + this.poolPreparedStatements);
        properties.put("defaultAutoCommit", "" + this.defaultAutoCommit);
        properties.put("initialSize", "" + this.initialSize);
        properties.put("maxWait", "" + this.maxWait.inMilliseconds());
        if (StringX.isNotBlank(this.validationQuery)) {
            properties.put("validationQuery", this.validationQuery);
        }
        properties.put("logAbandoned", "" + this.logAbandoned);
        properties.put("removeAbandoned", "" + this.removeAbandoned);
        properties.put("removeAbandonedTimeout", "" + (int)this.removeAbandonedTimeout.inSeconds());
        return properties;
    }
}

