/*
 * Decompiled with CFR 0.152.
 */
package net.model3.guice;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import net.model3.guice.DatabasePoolConfig;
import net.model3.guice.bootstrap.ConfigurationDirectory;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;
import net.model3.newfile.File;
import net.model3.xstream.XmlSerializableConfig;
import net.sf.log4jdbc.DriverSpy;
import org.apache.commons.dbcp.BasicDataSourceFactory;

@Singleton
@XStreamAlias(value="database")
public class DatabaseConfig
extends XmlSerializableConfig {
    private final transient Logger logger = LoggerHelper.getLogger();
    private String jdbcUrl = null;
    private String host = "localhost";
    private int port = 5432;
    private String protocol = "jdbc:postgresql:";
    private String driver = "org.postgresql.Driver";
    private String database = "mydb";
    private String user = "postgres";
    private String password = "postgresp1n2g3";
    private DatabasePoolConfig poolConfig = new DatabasePoolConfig();
    private boolean sqlLogging = true;

    public DatabaseConfig() {
    }

    @Inject
    public DatabaseConfig(ConfigurationDirectory configurationDirectory) {
        this((Directory)configurationDirectory.get());
    }

    public DatabaseConfig(Directory directory) {
        this.load(new File(directory, "database.xml"));
        this.saveSample(new DatabaseConfig());
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public boolean getSqlLogging() {
        return this.sqlLogging;
    }

    public void setSqlLogging(boolean bl) {
        this.sqlLogging = bl;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String string) {
        this.database = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public DatabasePoolConfig getPoolConfig() {
        return this.poolConfig;
    }

    public void setPoolConfig(DatabasePoolConfig databasePoolConfig) {
        this.poolConfig = databasePoolConfig;
    }

    public String getJdbcUrl() {
        if (this.jdbcUrl == null) {
            String string = this.getSqlLogging() ? "jdbc:log4" + this.protocol : this.protocol;
            return string + "//" + this.host + ":" + this.port + "/" + this.database;
        }
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String string) {
        this.jdbcUrl = string;
    }

    public Properties asDbcpProperties() {
        Properties properties = new Properties();
        properties.put("url", this.getJdbcUrl());
        if (this.getSqlLogging()) {
            properties.put("driverClassName", DriverSpy.class.getName());
        } else {
            properties.put("driverClassName", this.driver);
        }
        properties.put("username", this.getUser());
        properties.put("password", this.getPassword());
        properties.putAll((Map<?, ?>)this.poolConfig.asDbcpProperties());
        this.logger.info((Object)"using jdbc url {}", (Object)this.getJdbcUrl());
        return properties;
    }

    public String getDriver() {
        return this.driver;
    }

    public DataSource createDataSource() {
        try {
            this.logger.info((Object)"connecting to {}", (Object)this.getJdbcUrl());
            DataSource dataSource = BasicDataSourceFactory.createDataSource((Properties)this.asDbcpProperties());
            return dataSource;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

