/*
 * Decompiled with CFR 0.152.
 */
package net.model3.guice;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class CachingMethodInterceptor
implements MethodInterceptor {
    Map<MethodInvocationKey, AtomicReference<Object>> _methodCallStateCache = new ConcurrentHashMap<MethodInvocationKey, AtomicReference<Object>>();

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (methodInvocation.getMethod().getName().equals("clearCache")) {
            this.clearCache();
            return methodInvocation.proceed();
        }
        MethodInvocationKey methodInvocationKey = new MethodInvocationKey(methodInvocation);
        AtomicReference<Object> atomicReference = this._methodCallStateCache.get(methodInvocationKey);
        if (atomicReference == null) {
            atomicReference = new AtomicReference();
            atomicReference.set(methodInvocation.proceed());
            this._methodCallStateCache.put(methodInvocationKey, atomicReference);
        }
        return atomicReference.get();
    }

    public void clearCache() {
        this._methodCallStateCache.clear();
    }

    class MethodInvocationKey {
        Method _method;
        Object[] _parameters;
        Object _returnValue;

        MethodInvocationKey(MethodInvocation methodInvocation) {
            this._method = methodInvocation.getMethod();
            this._parameters = methodInvocation.getArguments();
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this._method == null ? 0 : this._method.hashCode());
            n = 31 * n + Arrays.hashCode(this._parameters);
            n = 31 * n + (this._returnValue == null ? 0 : this._returnValue.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            MethodInvocationKey methodInvocationKey = (MethodInvocationKey)object;
            if (this._method == null ? methodInvocationKey._method != null : !this._method.equals(methodInvocationKey._method)) {
                return false;
            }
            if (!Arrays.equals(this._parameters, methodInvocationKey._parameters)) {
                return false;
            }
            return !(this._returnValue == null ? methodInvocationKey._returnValue != null : !this._returnValue.equals(methodInvocationKey._returnValue));
        }
    }
}

