/*
 * Decompiled with CFR 0.152.
 */
package net.model3.collections;

import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.model3.collections.WeakValueEntry;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class WeakValueHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final Logger logger = LoggerHelper.getLogger(WeakValueHashMap.class);
    private Map<K, WeakValueEntry<K, V>> mapImpl_;
    private ReferenceQueue<V> queue_ = new ReferenceQueue();

    public WeakValueHashMap() {
        this.mapImpl_ = new HashMap<K, WeakValueEntry<K, V>>();
    }

    @Override
    public int size() {
        return this.mapImpl_.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mapImpl_.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.mapImpl_.containsKey(object);
    }

    @Override
    public V get(Object object) {
        this.processQueue();
        WeakValueEntry<K, V> weakValueEntry = this.mapImpl_.get(object);
        if (weakValueEntry == null) {
            return null;
        }
        return weakValueEntry.get();
    }

    @Override
    public V put(K k, V v) {
        this.processQueue();
        WeakValueEntry<K, V> weakValueEntry = new WeakValueEntry<K, V>(k, v, this.queue_);
        WeakValueEntry<K, V> weakValueEntry2 = this.mapImpl_.put(k, weakValueEntry);
        if (weakValueEntry2 == null) {
            return null;
        }
        return weakValueEntry2.get();
    }

    @Override
    public V remove(Object object) {
        this.processQueue();
        WeakValueEntry<K, V> weakValueEntry = this.mapImpl_.remove(object);
        return weakValueEntry.get();
    }

    @Override
    public void clear() {
        this.processQueue();
        this.mapImpl_.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new RuntimeException("not supported");
    }

    private void processQueue() {
        WeakValueEntry weakValueEntry;
        while ((weakValueEntry = (WeakValueEntry)this.queue_.poll()) != null) {
            if (weakValueEntry.get() != null) {
                weakValueEntry.get();
            }
            logger.trace((Object)("removing " + weakValueEntry.getKey()));
            this.mapImpl_.remove(weakValueEntry.getKey());
        }
    }
}

