/*
 * Decompiled with CFR 0.152.
 */
package net.model3.collections;

import java.util.List;
import net.model3.collections.ListX;

public class ThreadLocalStack<T> {
    private ThreadLocal<List<T>> local = new ThreadLocal<List<T>>(){

        @Override
        protected List<T> initialValue() {
            return ListX.create();
        }
    };

    public void push(T t) {
        this.local.get().add(t);
    }

    public Object get() {
        int n = this.local.get().size();
        if (n == 0) {
            return null;
        }
        return this.local.get().get(n - 1);
    }

    public T pop() {
        int n = this.local.get().size();
        return this.local.get().remove(n - 1);
    }

    public static final <T> ThreadLocalStack<T> create() {
        return new ThreadLocalStack<T>();
    }
}

