/*
 * Decompiled with CFR 0.152.
 */
package net.model3.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class SetX {
    private static final Logger logger = LoggerHelper.getLogger();
    public static final Iterator NULL_ITERATOR;
    private static final NavigableSet<Object> _emptyNavigableSet;

    Object get(Set set, Object object) {
        if (!set.contains(object)) {
            return null;
        }
        for (Object e : set) {
            if (!e.equals(object)) continue;
            return e;
        }
        return null;
    }

    public static <T> Set<T> createIdentitySet() {
        return new SetFromMap(new IdentityHashMap());
    }

    public static <T> Set<T> emptySet() {
        return Collections.emptySet();
    }

    public static <T> Set<T> createIdentitySet(Set<T> set) {
        Set<T> set2 = SetX.createIdentitySet();
        set2.addAll(set);
        return set2;
    }

    public static <T> Collection<T> subtract(Collection<T> collection, Collection<T> collection2) {
        HashSet<T> hashSet = new HashSet<T>();
        hashSet.addAll(collection);
        hashSet.removeAll(collection2);
        return hashSet;
    }

    public static <T> Set<T> intersection(Collection<T> ... collectionArray) {
        HashSet<T> hashSet = new HashSet<T>();
        if (collectionArray.length >= 1) {
            hashSet.addAll(collectionArray[0]);
        }
        for (int i = 1; i < collectionArray.length; ++i) {
            hashSet.retainAll(collectionArray[i]);
        }
        return hashSet;
    }

    public static <T> Set<T> intersection(Collection<T> collection, Collection<T> collection2) {
        HashSet<T> hashSet = new HashSet<T>();
        hashSet.addAll(collection);
        hashSet.retainAll(collection2);
        return hashSet;
    }

    public static <T> Set<T> create() {
        return new HashSet();
    }

    public static <T> Set<T> create(Iterable<T> iterable) {
        HashSet<T> hashSet = new HashSet<T>();
        for (T t : iterable) {
            hashSet.add(t);
        }
        return hashSet;
    }

    public static <T> Set<T> create(T ... TArray) {
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, TArray);
        return hashSet;
    }

    public static <T> NavigableSet<T> emptyNavigableSet() {
        return _emptyNavigableSet;
    }

    public static <T> Set<T> createSynchronized() {
        return Collections.synchronizedSet(new HashSet());
    }

    static {
        _emptyNavigableSet = new TreeSet<Object>(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean add(Object object) {
                throw new RuntimeException("empty set no adding allowed");
            }

            @Override
            public boolean addAll(Collection<? extends Object> collection) {
                throw new RuntimeException("empty set no adding allowed");
            }
        };
        NULL_ITERATOR = new Iterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            public Object next() {
                throw new RuntimeException("null iterator has no elements to next()");
            }

            @Override
            public void remove() {
                throw new RuntimeException("null iterator has no elements to remove()");
            }
        };
    }

    private static class SetFromMap<E>
    extends AbstractSet<E>
    implements Set<E>,
    Serializable {
        private final Map<E, Boolean> m;
        private transient Set<E> s;
        private static final long serialVersionUID = 2454657854757543876L;

        SetFromMap(Map<E, Boolean> map) {
            if (!map.isEmpty()) {
                throw new IllegalArgumentException("Map is non-empty");
            }
            this.m = map;
            this.s = map.keySet();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.m.remove(object) != null;
        }

        @Override
        public boolean add(E e) {
            return this.m.put(e, Boolean.TRUE) == null;
        }

        @Override
        public Iterator<E> iterator() {
            return this.s.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.s.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.s.toArray(TArray);
        }

        @Override
        public String toString() {
            return this.s.toString();
        }

        @Override
        public int hashCode() {
            return this.s.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return object == this || this.s.equals(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.s.containsAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.s.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.s.retainAll(collection);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.s = this.m.keySet();
        }
    }
}

