/*
 * Decompiled with CFR 0.152.
 */
package net.model3.collections;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.TimeDuration;

public class Queue<T> {
    private final LinkedBlockingQueue<T> _linkedQueue = new LinkedBlockingQueue();

    public boolean isEmpty() {
        return this._linkedQueue.isEmpty();
    }

    public void put(T t) {
        try {
            this._linkedQueue.put(t);
        }
        catch (InterruptedException interruptedException) {
            throw ExceptionPropagator.wrap(interruptedException);
        }
    }

    public T take() {
        try {
            return this._linkedQueue.take();
        }
        catch (InterruptedException interruptedException) {
            throw ExceptionPropagator.wrap(interruptedException);
        }
    }

    public int size() {
        return this._linkedQueue.size();
    }

    public Object poll(TimeDuration timeDuration) {
        try {
            return this._linkedQueue.poll(timeDuration.inMilliseconds(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw ExceptionPropagator.wrap(interruptedException);
        }
    }
}

