/*
 * Decompiled with CFR 0.152.
 */
package net.model3.collections;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;
import net.model3.newfile.File;

public class PropertyLoader {
    private static Logger logger = LoggerHelper.getLogger(PropertyLoader.class);

    public static Object loadProperties(Directory directory, String string, Properties properties) {
        try {
            Serializable serializable;
            InputStream inputStream;
            String string2 = "";
            if (directory != null) {
                string2 = "dir=" + directory.getCanonicalPath();
            }
            logger.debug((Object)"loading properties for {}    {}", (Object)string, (Object)string2);
            String string3 = string + ".properties";
            String string4 = string + "-override.properties";
            File file = new File(directory, string4);
            File file2 = new File(directory, string3);
            if (file.exists()) {
                inputStream = file.createInputStream();
                serializable = file;
            } else if (file2.exists()) {
                inputStream = file2.createInputStream();
                serializable = file2;
            } else {
                ClassLoader classLoader = PropertyLoader.class.getClassLoader();
                URL uRL = classLoader.getResource(string3);
                if (uRL == null) {
                    RuntimeException runtimeException = new RuntimeException("unable to find properties file " + string3 + " for " + string);
                    logger.fatal((Object)"", (Object)runtimeException);
                    throw runtimeException;
                }
                serializable = uRL;
                inputStream = classLoader.getResourceAsStream(string3);
            }
            logger.info((Object)("loading properties for " + string + " from " + serializable));
            properties.load(inputStream);
            return properties;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw ExceptionPropagator.wrap(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap(iOException);
        }
    }
}

