/*
 * Decompiled with CFR 0.152.
 */
package net.model3.collections;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.model3.collections.CollectionX;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.SystemX;
import net.model3.logging.Level;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.File;
import org.apache.log4j.BasicConfigurator;

public class PropertiesX
extends Properties {
    private static final long serialVersionUID = -7244497291700194273L;
    private static final Logger logger = LoggerHelper.getLogger();
    private boolean defaultGetPropertyThrowNotFoundException_ = false;

    public PropertiesX() {
    }

    public PropertiesX(File file) {
        this.loadWithHeadings(file);
    }

    public int getPropertyAsInt(String string) {
        String string2 = this.getProperty(string);
        if ((string2 = string2.trim()).startsWith("0x") || string2.startsWith("0X")) {
            return Integer.parseInt(string2.substring(2), 16);
        }
        return Integer.parseInt(string2);
    }

    public long getPropertyAsLong(String string) {
        String string2 = this.getProperty(string);
        if ((string2 = string2.trim()).startsWith("0x") || string2.startsWith("0X")) {
            return Long.parseLong(string2.substring(2), 16);
        }
        return Long.parseLong(string2);
    }

    public void loadWithHeadings(File file) {
        try {
            BufferedReader bufferedReader = file.createReader();
            this.loadWithHeadings(bufferedReader, file.getCanonicalPath());
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap(iOException);
        }
    }

    public void loadWithHeadings(InputStream inputStream) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            this.loadWithHeadings(bufferedReader, "input stream");
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap(iOException);
        }
    }

    public void loadWithHeadings(BufferedReader bufferedReader, String string) {
        try {
            String string2 = "";
            int n = 0;
            String string3 = null;
            try {
                while (true) {
                    ++n;
                    string3 = bufferedReader.readLine();
                    if (string3 != null) {
                        int n2;
                        if ((string3 = string3.trim()).startsWith("#") || string3.length() == 0) continue;
                        if (string3.startsWith("[")) {
                            n2 = string3.indexOf(93);
                            if (n2 < 0) {
                                throw new RuntimeException("no closing ] character found at ");
                            }
                            string2 = string3.substring(1, n2).trim() + ".";
                            continue;
                        }
                        n2 = string3.indexOf(61);
                        if (n2 < 0) {
                            throw new RuntimeException("no = sign found at ");
                        }
                        String string4 = string2 + string3.substring(0, n2).trim();
                        String string5 = string3.substring(n2 + 1).trim();
                        string5 = this.processEscapeSequences(string5);
                        this.setProperty(string4, string5);
                        continue;
                    }
                    break;
                }
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeException(runtimeException.getMessage() + "line " + n + ":" + string3 + " in " + string);
            }
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap(iOException);
        }
    }

    public static void logProperties(Properties properties, Level level) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("Logging properties for " + SystemX.identityToString(properties));
        Iterator<Object> iterator = CollectionX.sort(properties.keySet()).iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            String string2 = properties.getProperty(string);
            printWriter.println("        " + string + "=" + string2);
        }
        logger.log(level, stringWriter.toString());
    }

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        PropertiesX.logProperties(System.getProperties(), Level.INFO);
        System.exit(1);
        File file = new File("c:/a/test.props");
        PropertiesX propertiesX = new PropertiesX();
        propertiesX.loadWithHeadings(file);
        for (String string : propertiesX.keySet()) {
            String string2 = propertiesX.getProperty(string);
            System.out.println(string + "=" + string2);
        }
    }

    String processEscapeSequences(String string) {
        int n;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = string.indexOf(92, n = ++n2)) != -1) {
            stringBuffer.append(string.substring(n, n2));
            char c = string.charAt(n2 + 1);
            switch (c) {
                case 'n': {
                    stringBuffer.append('\n');
                    ++n2;
                }
            }
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static void print(Properties properties) {
        for (String string : properties.keySet()) {
            System.out.println(string + "=" + properties.getProperty(string));
        }
    }

    public void save(File file) {
        this.save(file, null);
    }

    public void save(File file, String string) {
        PrintStream printStream = file.createPrintStream();
        if (string != null) {
            printStream.println("#  " + string);
        }
        Object[] objectArray = this.keySet().toArray();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = objectArray[i].toString();
            String string3 = this.get(string2).toString();
            string2 = this.saveConvert(string2, true);
            string3 = this.saveConvert(string3, false);
            printStream.println(string2.toString() + "=" + string3.toString());
        }
        printStream.close();
    }

    private String saveConvert(String string, boolean bl) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    if (i == 0 || bl) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(PropertiesX.toHex(c >> 12 & 0xF));
                        stringBuffer.append(PropertiesX.toHex(c >> 8 & 0xF));
                        stringBuffer.append(PropertiesX.toHex(c >> 4 & 0xF));
                        stringBuffer.append(PropertiesX.toHex(c & 0xF));
                        continue block8;
                    }
                    if ("=: \t\r\n\f#!".indexOf(c) != -1) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String getProperty(String string) {
        return this.getProperty(string, this.defaultGetPropertyThrowNotFoundException_);
    }

    public String getProperty(String string, boolean bl) {
        String string2 = super.getProperty(string);
        if (bl && string2 == null) {
            throw new RuntimeException("key " + string + " not found.");
        }
        return string2;
    }

    private static char toHex(int n) {
        return "0123456789ABCDEF".charAt(n & 0xF);
    }

    public static String processStringForVariables(final Properties properties, String string, boolean bl) {
        VariableResolver variableResolver = new VariableResolver(){

            @Override
            public Object getVariableValue(String string) {
                return properties.getProperty(string);
            }
        };
        return PropertiesX.processStringForVariables(string, bl, variableResolver);
    }

    public static String processStringForVariables(final Map<String, String> map, String string, boolean bl) {
        VariableResolver variableResolver = new VariableResolver(){

            @Override
            public Object getVariableValue(String string) {
                return map.get(string);
            }
        };
        return PropertiesX.processStringForVariables(string, bl, variableResolver);
    }

    public static String processStringForVariables(String string, boolean bl, VariableResolver variableResolver) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if ((n = string.indexOf("${", n + 1)) < 0) {
                if (n3 == 0) {
                    return string;
                }
                if (n2 < string.length()) {
                    stringBuffer.append(string.substring(n2));
                }
                return stringBuffer.toString();
            }
            int n4 = string.indexOf("}", n);
            if (n4 < 0) continue;
            String string2 = string.substring(n + 2, n4).trim();
            Object object = variableResolver.getVariableValue(string2);
            if (object == null) {
                if (!bl) continue;
                throw new RuntimeException("no value associated with variable " + string2 + " in string '" + string + "'");
            }
            ++n3;
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(object.toString());
            n2 = n4 + 1;
        }
    }

    public static interface VariableResolver {
        public Object getVariableValue(String var1);
    }
}

