/*
 * Decompiled with CFR 0.152.
 */
package net.model3.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.model3.collections.Functor;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class ListX {
    private static final Logger logger = LoggerHelper.getLogger();
    private static final ListIterator EMPTY_LIST_ITERATOR = new ListIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            return null;
        }

        @Override
        public void remove() {
        }

        public void add(Object object) {
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        public Object previous() {
            return null;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        public void set(Object object) {
        }
    };

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY_LIST_ITERATOR;
    }

    public static <T> List<T> create() {
        return new ArrayList();
    }

    public static <T> List<T> emptyList() {
        return Collections.emptyList();
    }

    public static <T> void addAll(List<T> list, Iterable<T> iterable) {
        for (T t : iterable) {
            list.add(t);
        }
    }

    public static <T> List<T> create(T ... TArray) {
        List<T> list = ListX.create();
        for (T t : TArray) {
            list.add(t);
        }
        return list;
    }

    public static <T> List<T> create(Iterable<T> iterable) {
        return ListX.create(iterable, ListX.emptyList());
    }

    public static <T> List<T> create(Iterable<T> iterable, Iterable<T> iterable2) {
        int n = 5;
        int n2 = 1;
        while (true) {
            try {
                List<T> list = ListX.create();
                ListX.addAll(list, iterable);
                ListX.addAll(list, iterable2);
                return list;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                logger.debug((Object)"try {} of {} failed", (Object)n2, (Object)n, (Object)concurrentModificationException);
                if (n2 >= n) {
                    throw concurrentModificationException;
                }
                ++n2;
                continue;
            }
            break;
        }
    }

    public static <T> T getFirst(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static <T, U> List<T> reduce(List<U> list, Functor<T, U> functor) {
        List<T> list2 = ListX.create();
        for (U u : list) {
            list2.add(functor.call(u));
        }
        return list2;
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        return iterable.iterator().next();
    }

    public <T extends Comparable<T>> T getMinimum(Iterable<T> iterable) {
        T t = null;
        return t;
    }

    public static <T extends Number> double sum(Iterable<T> iterable) {
        double d = 0.0;
        for (Number number : iterable) {
            if (number == null) continue;
            d += number.doubleValue();
        }
        return d;
    }

    public static <T> List<T> getIntersection(List<T> list, List<T> list2) {
        List<T> list3 = ListX.create();
        for (T t : list) {
            if (!list2.contains(t)) continue;
            list3.add(t);
        }
        return list3;
    }

    public static <T> List<T> intersection(Collection<T> ... collectionArray) {
        List<T> list = ListX.create();
        if (collectionArray.length >= 1) {
            list.addAll(collectionArray[0]);
        }
        for (int i = 1; i < collectionArray.length; ++i) {
            list.retainAll(collectionArray[i]);
        }
        return list;
    }

    public static <T> List<T> intersection(Collection<T> collection, Collection<T> collection2) {
        List<T> list = ListX.create();
        if (collection != null && collection2 != null) {
            list.addAll(collection);
            list.retainAll(collection2);
        }
        return list;
    }
}

