/*
 * Decompiled with CFR 0.152.
 */
package net.model3.collections;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.model3.collections.MapX;
import net.model3.lang.ClassX;

public class GeneratedMap<K, V>
implements Map<K, V> {
    private Factory<K> _valueFactory;
    private Factory<V> _keyFactory;
    private Map<K, V> _delegate;

    public GeneratedMap(Factory<K> factory) {
        this._valueFactory = factory;
        this._delegate = MapX.create();
    }

    public GeneratedMap() {
        this._delegate = MapX.create();
    }

    public GeneratedMap(Map<K, V> map, Factory<K> factory) {
        this._valueFactory = factory;
        this._delegate = MapX.create();
    }

    @Override
    public V get(Object object) {
        V v = this._delegate.get(object);
        if (v == null) {
            v = this.generate(object);
            this._delegate.put(object, v);
        }
        return v;
    }

    public V generate(K k) {
        if (this._valueFactory == null) {
            final Class clazz = ClassX.getParameterizedType(this.getClass(), 1);
            this._valueFactory = new Factory<K>(){

                @Override
                public Object get(K k) {
                    return ClassX.newInstance(clazz);
                }
            };
        }
        return (V)this._valueFactory.get(k);
    }

    @Override
    public void clear() {
        this._delegate.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        return this._delegate.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this._delegate.containsValue(object);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._delegate.entrySet();
    }

    @Override
    public boolean equals(Object object) {
        return this._delegate.equals(object);
    }

    @Override
    public int hashCode() {
        return this._delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this._delegate.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this._delegate.keySet();
    }

    @Override
    public V put(K k, V v) {
        return this._delegate.put(k, v);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this._delegate.putAll(map);
    }

    @Override
    public V remove(Object object) {
        return this._delegate.remove(object);
    }

    @Override
    public int size() {
        return this._delegate.size();
    }

    public Map<K, V> getDelegate() {
        return this._delegate;
    }

    @Override
    public Collection<V> values() {
        return this._delegate.values();
    }

    public void add(V v) {
        Object object = this._keyFactory.get(v);
        this.put(object, v);
    }

    public void setValueFactory(Factory<K> factory) {
        this._valueFactory = factory;
    }

    public static <K, V> GeneratedMap<K, V> create() {
        return new GeneratedMap<K, V>();
    }

    public static <K, V> GeneratedMap<K, V> create(Factory<K> factory) {
        return new GeneratedMap<K, V>(factory);
    }

    public static interface Factory<K> {
        public Object get(K var1);
    }
}

