/*
 * Decompiled with CFR 0.152.
 */
package net.model3.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.model3.collections.ListX;
import net.model3.lang.NotImplementedException;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class CollectionX {
    private static final Logger logger = LoggerHelper.getLogger(CollectionX.class);
    private static final Iterator EMPTY_ITERATOR = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        @Override
        public void remove() {
        }
    };

    public static <T> List<T> sort(List<T> list, Comparator<?> comparator) {
        Collections.sort(list, comparator);
        return list;
    }

    public static Object[] toObjectArray(Collection<? extends Object> collection, Class clazz) {
        Object[] objectArray = (Object[])Array.newInstance(clazz, collection.size());
        collection.toArray(objectArray);
        return objectArray;
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> clazz) {
        Object[] objectArray = (Object[])Array.newInstance(clazz, collection.size());
        collection.toArray(objectArray);
        return objectArray;
    }

    public static String[] toStringArray(Collection collection) {
        return CollectionX.toArray(collection, String.class);
    }

    public static <T> Collection<T> addAll(Collection<T> collection, T ... TArray) {
        for (int i = 0; i < TArray.length; ++i) {
            collection.add(TArray[i]);
        }
        return collection;
    }

    public static void removeAll(Collection collection, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            collection.remove(objectArray[i]);
        }
    }

    public static <T> List<T> sort(Collection<T> collection) {
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        Collections.sort(arrayList);
        return arrayList;
    }

    public static <T> Iterator<T> getEmptyIterator(Class<T> clazz) {
        return EMPTY_ITERATOR;
    }

    public static <T> Iterator<T> getEmptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> T get(Iterable<T> iterable, int n) {
        int n2 = 0;
        for (T t : iterable) {
            if (n2 == n) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    public static <T> int indexOf(Iterable<T> iterable, T t) {
        int n = 0;
        for (T t2 : iterable) {
            if (!t2.equals(t)) continue;
            return n;
        }
        return -1;
    }

    public static Iterator getCollectionEntryIterator(Object object) {
        if (object == null) {
            return EMPTY_ITERATOR;
        }
        if (object instanceof Collection) {
            return ((Collection)object).iterator();
        }
        if (object instanceof Map) {
            return ((Map)object).values().iterator();
        }
        throw new RuntimeException("don't know how to handle type " + object.getClass());
    }

    public static <T> List<T> toList(T[] TArray) {
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, TArray);
        return arrayList;
    }

    public static <T> Collection<T> subtract(Collection<T> collection, Collection<T> collection2) {
        HashSet<T> hashSet = new HashSet<T>();
        hashSet.addAll(collection);
        hashSet.removeAll(collection2);
        return hashSet;
    }

    public static <T> Collection<T> intersection(Collection<T> ... collectionArray) {
        HashSet<T> hashSet = new HashSet<T>();
        hashSet.addAll(collectionArray[0]);
        for (int i = 1; i < collectionArray.length; ++i) {
            hashSet.retainAll(collectionArray[i]);
        }
        return hashSet;
    }

    public static <T> Iterable<T> iterable(final Enumeration<T> enumeration) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return enumeration.hasMoreElements();
                    }

                    @Override
                    public T next() {
                        return enumeration.nextElement();
                    }

                    @Override
                    public void remove() {
                        throw new NotImplementedException();
                    }
                };
            }
        };
    }

    public static <T> List<T> collect(Enumeration<T> enumeration) {
        List list = ListX.create();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list;
    }

    public static Object[] toObjectArray(Iterable<?> iterable) {
        List list = ListX.create();
        for (Object obj : iterable) {
            list.add(obj);
        }
        return list.toArray();
    }

    public static <T> T first(Set<T> set) {
        if (set.size() == 0) {
            return null;
        }
        return set.iterator().next();
    }
}

