/*
 * Decompiled with CFR 0.152.
 */
package net.model3.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.model3.collections.CaseInsensitiveSortedMapWrapper;

public class CaseInsensitiveMapWrapper<V>
implements Map<String, V>,
Serializable {
    private static final long serialVersionUID = -1073190322325191944L;
    private Map<String, V> impl_;

    public CaseInsensitiveMapWrapper() {
        this(new HashMap());
    }

    public CaseInsensitiveMapWrapper(Map<String, V> map) {
        this.impl_ = map;
        this.convertAllKeys();
    }

    @Override
    public void clear() {
        this.impl_.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.impl_.containsKey(this.convertKey(object));
    }

    @Override
    public boolean containsValue(Object object) {
        return this.impl_.containsValue(object);
    }

    @Override
    public Set entrySet() {
        return this.impl_.entrySet();
    }

    @Override
    public V get(Object object) {
        return this.impl_.get(this.convertKey(object));
    }

    @Override
    public boolean isEmpty() {
        return this.impl_.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.impl_.keySet();
    }

    @Override
    public V put(String string, V v) {
        return this.impl_.put(string.toLowerCase(), v);
    }

    @Override
    public void putAll(Map map) {
        this.impl_.putAll(map);
        if (!(map instanceof CaseInsensitiveMapWrapper) && !(map instanceof CaseInsensitiveSortedMapWrapper)) {
            this.convertAllKeys();
        }
    }

    @Override
    public V remove(Object object) {
        return this.impl_.remove(this.convertKey(object));
    }

    @Override
    public int size() {
        return this.impl_.size();
    }

    @Override
    public Collection values() {
        return this.impl_.values();
    }

    protected Object convertKey(Object object) {
        if (object instanceof String) {
            return object.toString().toLowerCase();
        }
        return object;
    }

    protected void convertAllKeys() {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String object2 : this.keySet()) {
            string = object2.toLowerCase();
            if (string.equals(object2)) continue;
            arrayList.add(object2);
            arrayList2.add(string);
        }
        Iterator<String> iterator = arrayList.iterator();
        Iterator iterator2 = arrayList2.iterator();
        while (iterator.hasNext()) {
            string = iterator.next();
            String string2 = (String)iterator2.next();
            V v = this.remove(string);
            this.put(string2, v);
        }
    }

    public Map getImpl() {
        return this.impl_;
    }

    public static <V> Map<String, V> create() {
        return new CaseInsensitiveMapWrapper<V>();
    }
}

