/*
 * Decompiled with CFR 0.152.
 */
package net.model3.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.model3.lang.SystemX;

public class ArrayX {
    public static Object[] primitiveToReference(Object object) {
        Object[] objectArray;
        if (!object.getClass().isArray() || !object.getClass().getComponentType().isPrimitive()) {
            throw new RuntimeException("not a primitive array");
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            objectArray = new Object[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                objectArray[i] = new Byte(byArray[i]);
            }
        } else if (object instanceof short[]) {
            byte[] byArray = (byte[])object;
            objectArray = new Object[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                objectArray[i] = new Byte(byArray[i]);
            }
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            objectArray = new Object[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                objectArray[i] = new Integer(nArray[i]);
            }
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            objectArray = new Object[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                objectArray[i] = new Long(lArray[i]);
            }
        } else if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            objectArray = new Object[blArray.length];
            for (int i = 0; i < blArray.length; ++i) {
                objectArray[i] = new Boolean(blArray[i]);
            }
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            objectArray = new Object[fArray.length];
            for (int i = 0; i < fArray.length; ++i) {
                objectArray[i] = new Float(fArray[i]);
            }
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            objectArray = new Object[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                objectArray[i] = new Double(dArray[i]);
            }
        } else {
            throw new RuntimeException("don't know how to handle type " + object.getClass().getName());
        }
        return objectArray;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static <T> List<T> arrayToList(T[] TArray) {
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, TArray);
        return arrayList;
    }

    public static String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(",");
            }
            if (stringArray[i] != null) {
                stringBuffer.append('\"');
            }
            stringBuffer.append(stringArray[i]);
            if (stringArray[i] == null) continue;
            stringBuffer.append('\"');
        }
        return stringBuffer.toString();
    }

    public static <T> T[] resizeArray(T[] TArray, int n) {
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n + TArray.length);
        SystemX.arraycopy(TArray, objectArray);
        return objectArray;
    }

    public static boolean arrayContentsEqual(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return objectArray2 == null;
        }
        if (objectArray2 == null) {
            return false;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            Object object2 = objectArray2[i];
            if (object == null) {
                if (object2 == null) continue;
                return false;
            }
            if (object2 == null) {
                return false;
            }
            if (object.equals(object2)) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] makeArray(T ... TArray) {
        return TArray;
    }

    public static <T> List<T> asList(T[] TArray) {
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, TArray);
        return arrayList;
    }

    public static <T> Iterator<T> asIterator(T[] TArray) {
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, TArray);
        return arrayList.iterator();
    }
}

