/*
 * Decompiled with CFR 0.152.
 */
package net.model3.chrono;

import java.util.Iterator;
import java.util.List;
import net.model3.chrono.TimeOnly;
import net.model3.chrono.TimeRange;
import net.model3.collections.ListX;
import net.model3.lang.TimeDuration;

public class TimeRangeIterable
implements Iterable<TimeOnly> {
    TimeRange _range;
    boolean _inclusiveEnd;
    TimeDuration _increment;
    transient List<TimeOnly> _times;

    public TimeRangeIterable(TimeRange timeRange, boolean bl, TimeDuration timeDuration) {
        this._range = timeRange;
        this._inclusiveEnd = bl;
        this._increment = timeDuration;
    }

    public TimeRangeIterable(TimeOnly timeOnly, TimeOnly timeOnly2, boolean bl, TimeDuration timeDuration) {
        this._range = new TimeRange(timeOnly, timeOnly2);
        this._inclusiveEnd = bl;
        this._increment = timeDuration;
    }

    public TimeRangeIterable(TimeOnly timeOnly, TimeOnly timeOnly2, TimeDuration timeDuration) {
        this(timeOnly, timeOnly2, true, timeDuration);
    }

    public TimeRangeIterable(TimeRange timeRange, TimeDuration timeDuration) {
        this(timeRange, false, timeDuration);
    }

    @Override
    public Iterator<TimeOnly> iterator() {
        return this.getTimes().iterator();
    }

    public boolean contains(TimeOnly timeOnly) {
        return this._range.contains(timeOnly);
    }

    public TimeDuration getDuration() {
        return this._range.getDuration();
    }

    public List<TimeOnly> getTimes() {
        if (this._times != null) {
            return this._times;
        }
        List<TimeOnly> list = ListX.create();
        TimeOnly timeOnly = this._range.getStart();
        TimeOnly timeOnly2 = this._range.getEnd();
        while (!(this._inclusiveEnd && timeOnly.greaterThan(timeOnly2) || !this._inclusiveEnd && timeOnly.greaterThanOrEqual(timeOnly2))) {
            list.add(timeOnly);
            timeOnly = timeOnly.add(this._increment);
        }
        this._times = list;
        return this._times;
    }

    public TimeRange getRange() {
        return this._range;
    }

    public TimeDuration getIncrement() {
        return this._increment;
    }

    public TimeOnly getStart() {
        return this.getRange().getStart();
    }

    public int getCount() {
        return this.getTimes().size();
    }

    public TimeOnly getEnd() {
        return this.getRange().getEnd();
    }

    public int indexOf(TimeOnly timeOnly) {
        if (this.getRange().contains(timeOnly)) {
            int n = timeOnly.inMillis() - this.getStart().inMillis();
            int n2 = n / (int)this.getIncrement().inMilliseconds();
            return n2;
        }
        return -1;
    }

    public boolean isInclusiveEnd() {
        return this._inclusiveEnd;
    }

    public TimeRangeIterable withNonInclusiveEnd() {
        if (this._inclusiveEnd) {
            return new TimeRangeIterable(this._range, false, this._increment);
        }
        return this;
    }
}

