/*
 * Decompiled with CFR 0.152.
 */
package net.model3.chrono;

import java.io.Serializable;
import net.model3.chrono.TimeOnly;
import net.model3.chrono.TimeRangeIterable;
import net.model3.lang.TimeDuration;

public class TimeRange
implements Serializable {
    private static final long serialVersionUID = 9032014005118608278L;
    TimeOnly _start;
    TimeOnly _end;

    public TimeRange() {
    }

    public TimeRange(TimeOnly timeOnly, TimeOnly timeOnly2) {
        this._start = timeOnly;
        this._end = timeOnly2;
        if (this._end == null && this._start == null) {
            throw new NullPointerException();
        }
        if (this._start == null) {
            this._start = this._end;
        }
        if (this._end == null) {
            this._end = this._start;
        }
        if (this._end.lessThan(this._start)) {
            TimeOnly timeOnly3 = this._end;
            this._end = this._start;
            this._start = timeOnly3;
        }
    }

    public TimeRange(TimeOnly timeOnly) {
        this(timeOnly, null);
    }

    public boolean contains(TimeOnly timeOnly) {
        if (this._start == null) {
            return false;
        }
        return timeOnly.greaterThanOrEqual(this._start) && timeOnly.lessThanOrEqual(this._end);
    }

    public TimeDuration getDuration() {
        return TimeDuration.fromMilliseconds(this._end.inMillis() - this._start.inMillis());
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._end == null ? 0 : this._end.hashCode());
        n = 31 * n + (this._start == null ? 0 : this._start.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TimeRange timeRange = (TimeRange)object;
        if (this._end == null ? timeRange._end != null : !this._end.equals(timeRange._end)) {
            return false;
        }
        return !(this._start == null ? timeRange._start != null : !this._start.equals(timeRange._start));
    }

    public String toString() {
        if (this._start == null) {
            return "null-range";
        }
        return this._start + " to " + this._end;
    }

    public Iterable<TimeOnly> iter(TimeDuration timeDuration) {
        return this.iter(timeDuration, false);
    }

    public TimeRangeIterable iter(TimeDuration timeDuration, boolean bl) {
        return new TimeRangeIterable(this, bl, timeDuration);
    }

    public TimeOnly getStart() {
        return this._start;
    }

    public TimeOnly getEnd() {
        return this._end;
    }
}

