/*
 * Decompiled with CFR 0.152.
 */
package net.model3.chrono;

import java.io.Serializable;
import java.sql.Time;
import java.text.ParseException;
import java.util.Date;
import net.model3.chrono.DateFormatter;
import net.model3.chrono.DateOnly;
import net.model3.chrono.DateTime;
import net.model3.chrono.Meridian;
import net.model3.chrono.TimeProvider;
import net.model3.lang.AbstractComparable;
import net.model3.lang.StringX;
import net.model3.lang.TimeDuration;

public class TimeOnly
extends AbstractComparable<TimeOnly>
implements TimeProvider,
Serializable {
    private static final long serialVersionUID = -1139954411597601943L;
    private static final DateFormatter _dateFormatterMillis = new DateFormatter("HH:mm:ss.SSS");
    private static final DateFormatter _jsonDateFormatter = new DateFormatter("h:mm:ss aa");
    private static final DateFormatter[] _uberFormatters = new DateFormatter[]{new DateFormatter("h:mmaa"), new DateFormatter("h:mm aa"), new DateFormatter("haa"), new DateFormatter("h aa"), new DateFormatter("H:mm"), new DateFormatter("H")};
    public static final TimeOnly FIRST_MOMENT_IN_DAY = new TimeOnly(0, 0, 0, 0);
    public static final TimeOnly LAST_MOMENT_IN_DAY = new TimeOnly(23, 59, 59, 999);
    private final int _millisecondsSinceMidnight;

    public TimeOnly() {
        this(new Time(System.currentTimeMillis()));
    }

    public TimeOnly(String string) {
        this(TimeOnly.parse((String)string)._millisecondsSinceMidnight);
    }

    public TimeOnly(int n) {
        this._millisecondsSinceMidnight = n;
    }

    public TimeOnly(int n, int n2, int n3) {
        this(n, n2, n3, 0);
    }

    public TimeOnly(Time time) {
        this(time.getHours(), time.getMinutes(), time.getSeconds(), 0);
    }

    public TimeOnly(int n, int n2, int n3, int n4) {
        int n5 = 0;
        n5 = (int)((long)n5 + (long)n * 3600000L);
        n5 = (int)((long)n5 + (long)n2 * 60000L);
        n5 += n3 * 1000;
        this._millisecondsSinceMidnight = n5 += n4;
    }

    @Override
    public int compareTo(TimeOnly timeOnly) {
        int n = this._millisecondsSinceMidnight - timeOnly._millisecondsSinceMidnight;
        if (n != 0) {
            n /= Math.abs(n);
        }
        return n;
    }

    @Override
    public int getHourAs12Hour() {
        int n = this.getHour();
        if (n == 0) {
            return 12;
        }
        if (n > 12) {
            return n - 12;
        }
        return n;
    }

    @Override
    public int getHour() {
        return (int)((long)this._millisecondsSinceMidnight / 3600000L);
    }

    @Override
    public int getMinutes() {
        return (int)((long)this._millisecondsSinceMidnight % 3600000L / 60000L);
    }

    @Override
    public int getSeconds() {
        return (int)((long)this._millisecondsSinceMidnight % 60000L / 1000L);
    }

    @Override
    public int getMillisecond() {
        return this._millisecondsSinceMidnight % 1000;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this._millisecondsSinceMidnight;
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TimeOnly timeOnly = (TimeOnly)object;
        return this._millisecondsSinceMidnight == timeOnly._millisecondsSinceMidnight;
    }

    public int inMillis() {
        return this._millisecondsSinceMidnight;
    }

    public String asHourMinuteMeridianString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getHourAs12Hour());
        stringBuilder.append(":");
        StringX.appendNumeric(stringBuilder, this.getMinutes(), 2);
        stringBuilder.append(' ' + this.getMeridian().name());
        return stringBuilder.toString();
    }

    @Override
    public Meridian getMeridian() {
        if (this.getHour() < 12) {
            return Meridian.AM;
        }
        return Meridian.PM;
    }

    public Date asDate() {
        return new Date(2000, 1, 1, this.getHour(), this.getMinutes(), this.getSeconds());
    }

    @Override
    public DateTime asDateTime(DateOnly dateOnly) {
        return new DateTime(dateOnly, this);
    }

    public String toJSONString() {
        return '\"' + _jsonDateFormatter.format(this.asDateTime(new DateOnly())) + '\"';
    }

    public TimeOnly add(TimeDuration timeDuration) {
        return new TimeOnly((int)((long)this.inMillis() + timeDuration.inMilliseconds()));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getHour());
        stringBuilder.append(":");
        StringX.appendNumeric(stringBuilder, this.getMinutes(), 2);
        stringBuilder.append(":");
        StringX.appendNumeric(stringBuilder, this.getSeconds(), 2);
        stringBuilder.append(".");
        StringX.appendNumeric(stringBuilder, this.getMillisecond(), 3);
        return stringBuilder.toString();
    }

    public String inMilitaryTime() {
        StringBuilder stringBuilder = new StringBuilder();
        StringX.appendNumeric(stringBuilder, this.getHour(), 2);
        stringBuilder.append(":");
        StringX.appendNumeric(stringBuilder, this.getMinutes(), 2);
        return stringBuilder.toString();
    }

    public static final TimeOnly parse(String string) {
        for (DateFormatter dateFormatter : _uberFormatters) {
            try {
                DateTime dateTime = dateFormatter.parse(string);
                return dateTime.asTimeOnly();
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    public static void main(String[] stringArray) {
        System.out.println(TimeOnly.parse("8am"));
        System.out.println(TimeOnly.parse("8 am"));
        System.out.println(TimeOnly.parse("8:00am"));
        System.out.println(TimeOnly.parse("8:00 am"));
    }

    @Override
    public TimeOnly asTimeOnly() {
        return this;
    }
}

