/*
 * Decompiled with CFR 0.152.
 */
package net.model3.chrono;

public enum Month {
    January,
    February,
    March,
    April,
    May,
    June,
    July,
    August,
    September,
    October,
    November,
    December;

    String _threeCharAbbrev = this.name().substring(0, 3);
    String _twoCharAbbrev = this.name().substring(0, 2);

    public String getThreeCharAbbrev() {
        return this._threeCharAbbrev;
    }

    public String getTwoCharAbbrev() {
        return this._twoCharAbbrev;
    }

    public Month nextMonth() {
        int n = this.ordinal() + 1;
        if (n >= Month.values().length) {
            n = 0;
        }
        return Month.values()[n];
    }

    public Month previousMonth() {
        int n = this.ordinal() + 1;
        if (n < 0) {
            n = Month.values().length - 1;
        }
        return Month.values()[n];
    }

    public int number() {
        return this.ordinal() + 1;
    }

    public static Month fromNumber(int n) {
        if (n >= 1 && n <= 12) {
            return Month.values()[n - 1];
        }
        return null;
    }

    public static Month fromTwoCharAbbrev(String string) {
        for (Month month : Month.values()) {
            if (!month._twoCharAbbrev.equals(string)) continue;
            return month;
        }
        return null;
    }

    public static Month fromThreeCharAbbrev(String string) {
        for (Month month : Month.values()) {
            if (!month._threeCharAbbrev.equals(string)) continue;
            return month;
        }
        return null;
    }
}

