/*
 * Decompiled with CFR 0.152.
 */
package net.model3.chrono;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.model3.chrono.DateTime;
import net.model3.chrono.DateTimeRange;

public class DateTimeRangeList
implements Iterable<DateTimeRange>,
Serializable {
    private static final long serialVersionUID = 549672082014864222L;
    private List<DateTimeRange> _dateTimeRanges;

    public DateTimeRangeList(List<DateTimeRange> list) {
        this._dateTimeRanges = list;
        this.sort();
        this.processOverlaps();
    }

    public DateTimeRangeList() {
        this._dateTimeRanges = new LinkedList<DateTimeRange>();
        this.sort();
        this.processOverlaps();
    }

    public DateTimeRangeList(DateTimeRange dateTimeRange) {
        this._dateTimeRanges = new LinkedList<DateTimeRange>();
        this._dateTimeRanges.add(dateTimeRange);
        this.sort();
        this.processOverlaps();
    }

    @Override
    public Iterator<DateTimeRange> iterator() {
        return this._dateTimeRanges.iterator();
    }

    public List<DateTimeRange> getDateTimeRanges() {
        return this._dateTimeRanges;
    }

    public void add(DateTimeRange dateTimeRange) {
        this._dateTimeRanges.add(dateTimeRange);
        this.sort();
        this.processOverlaps();
    }

    public void addAll(DateTimeRangeList dateTimeRangeList) {
        this._dateTimeRanges.addAll(dateTimeRangeList._dateTimeRanges);
        this.sort();
        this.processOverlaps();
    }

    public void sort() {
        Collections.sort(this._dateTimeRanges, DateTimeRange.StartComparator);
    }

    public void processOverlaps() {
        int n = 0;
        while (n + 1 <= this._dateTimeRanges.size() - 1) {
            if (this._dateTimeRanges.get(n).getFinish().greaterThanOrEqual(this._dateTimeRanges.get(n + 1).getStart())) {
                DateTime dateTime = this._dateTimeRanges.get(n).getFinish().max(this._dateTimeRanges.get(n + 1).getFinish());
                this._dateTimeRanges.set(n, new DateTimeRange(this._dateTimeRanges.get(n).getStart(), dateTime));
                this._dateTimeRanges.remove(n + 1);
                continue;
            }
            ++n;
        }
    }

    public Boolean overlaps(DateTimeRange dateTimeRange) {
        for (DateTimeRange dateTimeRange2 : this._dateTimeRanges) {
            if (!dateTimeRange2.overlaps(dateTimeRange).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public DateTimeRangeList subtract(DateTimeRange dateTimeRange) {
        DateTimeRangeList dateTimeRangeList = new DateTimeRangeList();
        for (DateTimeRange dateTimeRange2 : this._dateTimeRanges) {
            dateTimeRangeList.addAll(dateTimeRange2.subtract(dateTimeRange));
        }
        return dateTimeRangeList;
    }

    public DateTimeRangeList subtract(DateTimeRangeList dateTimeRangeList) {
        DateTimeRangeList dateTimeRangeList2 = new DateTimeRangeList();
        dateTimeRangeList2.addAll(this);
        for (DateTimeRange dateTimeRange : dateTimeRangeList._dateTimeRanges) {
            dateTimeRangeList2 = dateTimeRangeList2.subtract(dateTimeRange);
        }
        return dateTimeRangeList2;
    }

    public String toString() {
        String string = "DateTimeRangeList with " + this._dateTimeRanges.size() + " elements";
        for (int i = 0; i < this._dateTimeRanges.size(); ++i) {
            string = string + "\n  " + i + ": " + this._dateTimeRanges.get(i).toString();
        }
        return string;
    }
}

