/*
 * Decompiled with CFR 0.152.
 */
package net.model3.chrono;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import net.model3.chrono.DateTime;
import net.model3.chrono.DateTimeRangeList;
import net.model3.lang.TimeDuration;

public class DateTimeRange
implements Serializable {
    private static final long serialVersionUID = -299307237665097314L;
    private DateTime _start;
    private DateTime _finish;
    private TimeDuration _duration;
    public static Comparator<DateTimeRange> StartComparator = new Comparator<DateTimeRange>(){

        @Override
        public int compare(DateTimeRange dateTimeRange, DateTimeRange dateTimeRange2) {
            return dateTimeRange.getStart().compareTo(dateTimeRange2.getStart());
        }
    };

    public DateTimeRange() {
        this._start = null;
        this._finish = null;
    }

    public DateTimeRange(DateTime dateTime, TimeDuration timeDuration) {
        this._start = dateTime;
        this._finish = dateTime.add(timeDuration);
    }

    public DateTimeRange(DateTime dateTime, DateTime dateTime2) {
        this._start = dateTime;
        this._finish = dateTime2;
    }

    public DateTimeRange(List<DateTime> list) {
        for (DateTime dateTime : list) {
            if (this._start == null) {
                this._start = dateTime;
            } else if (dateTime.lessThan(this._start)) {
                this._start = dateTime;
            }
            if (this._finish == null) {
                this._finish = dateTime;
                continue;
            }
            if (!dateTime.greaterThan(this._finish)) continue;
            this._finish = dateTime;
        }
    }

    public TimeDuration getTimeDuration() {
        if (this._duration == null && this._start != null) {
            this._duration = this._finish.diff(this._start);
        }
        return this._duration;
    }

    public DateTime getStart() {
        return this._start;
    }

    public DateTime getFinish() {
        return this._finish;
    }

    public Boolean equals(DateTimeRange dateTimeRange) {
        return this.getStart().equals(dateTimeRange.getStart()) && this.getFinish().equals(dateTimeRange.getFinish());
    }

    public Boolean contains(DateTime dateTime) {
        return dateTime.greaterThanOrEqual(this._start) && dateTime.lessThanOrEqual(this._finish);
    }

    public DateTimeRange extend(DateTime dateTime) {
        if (dateTime.lessThan(this._start)) {
            return new DateTimeRange(dateTime, this._finish);
        }
        if (dateTime.greaterThan(this._finish)) {
            return new DateTimeRange(this._start, dateTime);
        }
        return this;
    }

    public DateTimeRange extend(DateTimeRange dateTimeRange) {
        DateTime dateTime = this._start == null ? dateTimeRange.getStart() : (dateTimeRange.getStart() == null ? this._start : this._start.min(dateTimeRange.getStart()));
        DateTime dateTime2 = this._finish == null ? dateTimeRange.getFinish() : (dateTimeRange.getFinish() == null ? this._finish : this._finish.max(dateTimeRange.getFinish()));
        return new DateTimeRange(dateTime, dateTime2);
    }

    public DateTimeRange buffer(TimeDuration timeDuration) {
        DateTime dateTime = this._start == null ? null : this._start.subtract(timeDuration);
        DateTime dateTime2 = this._finish == null ? null : this._finish.add(timeDuration);
        return new DateTimeRange(dateTime, dateTime2);
    }

    public DateTimeRange union(DateTimeRange dateTimeRange) {
        return this.extend(dateTimeRange);
    }

    public Boolean overlaps(DateTimeRange dateTimeRange) {
        DateTime dateTime;
        DateTime dateTime2;
        if (this._start.lessThanOrEqual(dateTimeRange.getStart())) {
            dateTime2 = this._finish;
            dateTime = dateTimeRange.getStart();
        } else {
            dateTime = this._start;
            dateTime2 = dateTimeRange.getFinish();
        }
        if (dateTime.lessThan(dateTime2)) {
            return true;
        }
        return false;
    }

    public DateTimeRange intersection(DateTimeRange dateTimeRange) {
        DateTimeRange dateTimeRange2;
        DateTimeRange dateTimeRange3;
        if (this.getStart().lessThanOrEqual(dateTimeRange.getStart())) {
            dateTimeRange3 = this;
            dateTimeRange2 = dateTimeRange;
        } else {
            dateTimeRange2 = this;
            dateTimeRange3 = dateTimeRange;
        }
        if (dateTimeRange3.getFinish().greaterThanOrEqual(dateTimeRange2.getStart())) {
            return new DateTimeRange(dateTimeRange2.getStart(), dateTimeRange3.getFinish().min(dateTimeRange2.getFinish()));
        }
        return null;
    }

    public DateTimeRange gapTo(DateTimeRange dateTimeRange) {
        DateTimeRange dateTimeRange2;
        DateTimeRange dateTimeRange3;
        if (this.getStart().lessThanOrEqual(dateTimeRange.getStart())) {
            dateTimeRange3 = this;
            dateTimeRange2 = dateTimeRange;
        } else {
            dateTimeRange2 = this;
            dateTimeRange3 = dateTimeRange;
        }
        if (dateTimeRange3.getFinish().lessThan(dateTimeRange2.getStart())) {
            return new DateTimeRange(dateTimeRange3.getFinish(), dateTimeRange2.getStart());
        }
        return null;
    }

    public DateTimeRangeList subtract(DateTimeRange dateTimeRange) {
        DateTimeRangeList dateTimeRangeList = new DateTimeRangeList();
        if (!this.overlaps(dateTimeRange).booleanValue()) {
            dateTimeRangeList.add(this);
            return dateTimeRangeList;
        }
        if (this.getStart().lessThan(dateTimeRange.getStart())) {
            dateTimeRangeList.add(new DateTimeRange(this.getStart(), dateTimeRange.getStart()));
        }
        if (this.getFinish().greaterThan(dateTimeRange.getFinish())) {
            dateTimeRangeList.add(new DateTimeRange(dateTimeRange.getFinish(), this.getFinish()));
        }
        return dateTimeRangeList;
    }

    public String toString() {
        return "Start = " + this._start + ", Finish = " + this._finish;
    }
}

