/*
 * Decompiled with CFR 0.152.
 */
package net.model3.chrono;

import java.text.ParseException;
import net.model3.bean.converters.AbstractGenericConverter;
import net.model3.chrono.DateTime;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.text.ThreadSafeSimpleDateFormat;

public class DateTimeConverter
extends AbstractGenericConverter<DateTime> {
    private static final Logger logger = LoggerHelper.getLogger();
    ThreadSafeSimpleDateFormat sdf = new ThreadSafeSimpleDateFormat("MM/dd/yyyy hh:mm a");

    @Override
    public String valueToString(DateTime dateTime) {
        return this.sdf.format(dateTime.asDate());
    }

    @Override
    public DateTime stringToValue(Class<?> clazz, String string) {
        try {
            return DateTime.wrap(this.sdf.parse(string));
        }
        catch (ParseException parseException) {
            logger.error((Object)"Could not convert {}", (Object)string);
            throw new RuntimeException(parseException);
        }
    }
}

