/*
 * Decompiled with CFR 0.152.
 */
package net.model3.chrono;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.model3.chrono.ChronoHelper;
import net.model3.chrono.DateFormatter;
import net.model3.chrono.DateOnly;
import net.model3.chrono.DateProvider;
import net.model3.chrono.DayOfWeek;
import net.model3.chrono.Meridian;
import net.model3.chrono.Month;
import net.model3.chrono.TimeOnly;
import net.model3.chrono.TimeProvider;
import net.model3.lang.AbstractComparable;
import net.model3.lang.LongX;
import net.model3.lang.TimeDuration;

public class DateTime
extends AbstractComparable<DateTime>
implements Serializable,
Cloneable,
DateProvider,
TimeProvider {
    private static final long serialVersionUID = 271975900318193867L;
    private static final DateFormatter _javaScriptDateFormatter = new DateFormatter("'new Date(\"'MM/dd/yyyy HH:mm:ss 'GMT' Z'\")'");
    private final GregorianCalendar _delegate;

    public DateTime() {
        this._delegate = new GregorianCalendar();
    }

    public DateTime(int n, Month month, int n2, int n3, int n4, int n5) {
        this(n, month.number(), n2, n3, n4, n5, null);
    }

    public DateTime(int n, Month month, int n2, int n3, int n4, int n5, TimeZone timeZone) {
        this(n, month.number(), n2, n3, n4, n5, timeZone);
    }

    public DateTime(DateOnly dateOnly, TimeOnly timeOnly) {
        this(dateOnly, timeOnly, null);
    }

    public DateTime(DateOnly dateOnly, TimeOnly timeOnly, TimeZone timeZone) {
        this(dateOnly.getYear(), dateOnly.getMonthNumber(), dateOnly.getDay(), timeOnly.getHour(), timeOnly.getMinutes(), timeOnly.getSeconds(), timeZone);
    }

    public DateTime(long l) {
        this(l, null);
    }

    public DateTime(long l, TimeZone timeZone) {
        this._delegate = new GregorianCalendar();
        this._delegate.setTime(new java.util.Date(l));
        if (timeZone != null) {
            this._delegate.setTimeZone(timeZone);
        }
    }

    private DateTime(int n, Month month, int n2, int n3, int n4, TimeZone timeZone) {
        this(n, month, n2, n3, n4, 0, timeZone);
    }

    private DateTime(int n, int n2, int n3, int n4, int n5, int n6) {
        this(n, n2, n3, n4, n5, n6, null);
    }

    private DateTime(int n, int n2, int n3, int n4, int n5, int n6, TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        this._delegate = new GregorianCalendar(timeZone);
        this._delegate.set(n, n2 - 1, n3, n4, n5, n6);
        this._delegate.set(14, 0);
    }

    public DateTime(GregorianCalendar gregorianCalendar) {
        this._delegate = (GregorianCalendar)gregorianCalendar.clone();
    }

    public DateTime(java.util.Date date) {
        this._delegate = new GregorianCalendar();
        this._delegate.setTime(date);
    }

    public DateTime(int n, Month month, int n2, int n3, int n4) {
        this(n, month.number(), n2, n3, n4, 0);
    }

    public DateTime(DateTime dateTime, TimeZone timeZone) {
        this(dateTime.asDate(), timeZone);
    }

    public DateTime(java.util.Date date, TimeZone timeZone) {
        this._delegate = new GregorianCalendar(timeZone);
        this._delegate.setTime(date);
    }

    @Override
    public boolean isToday() {
        return ChronoHelper.Instance.isToday(this);
    }

    @Override
    public boolean isTomorrow() {
        return ChronoHelper.Instance.isTomorrow(this);
    }

    @Override
    public int getYear() {
        return this._delegate.get(1);
    }

    public int getDecade() {
        return this.getYear() / 10 * 10;
    }

    @Override
    public Month getMonth() {
        return Month.values()[this.getMonthIndex()];
    }

    @Override
    public int getMonthIndex() {
        return this._delegate.get(2);
    }

    @Override
    public int getMonthNumber() {
        return this._delegate.get(2) + 1;
    }

    @Override
    public int getDay() {
        return this._delegate.get(5);
    }

    @Override
    public DayOfWeek getDayOfWeek() {
        return DayOfWeek.values()[this._delegate.get(7) - 1];
    }

    @Override
    public int getHour() {
        return this._delegate.get(11);
    }

    @Override
    public int getMinutes() {
        return this._delegate.get(12);
    }

    @Override
    public int getSeconds() {
        return this._delegate.get(13);
    }

    @Override
    public int getMillisecond() {
        return this._delegate.get(14);
    }

    @Override
    public DateTime add(int n, int n2) {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)this._delegate.clone();
        gregorianCalendar.add(n, n2);
        DateTime dateTime = new DateTime(gregorianCalendar);
        return dateTime;
    }

    @Override
    public DateTime add(TimeDuration timeDuration) {
        return this.add(13, (int)timeDuration.inSeconds());
    }

    public DateTime addYears(int n) {
        return this.add(1, n);
    }

    public DateTime addMonths(int n) {
        return this.add(2, n);
    }

    public DateTime subtractMonths(int n) {
        return this.addMonths(n * -1);
    }

    public DateTime subtractDays(int n) {
        return this.addDays(n * -1);
    }

    public DateTime addDays(int n) {
        return this.add(5, n);
    }

    public DateTime addHours(int n) {
        return this.add(10, n);
    }

    public Timestamp asSqlTimestamp() {
        return new Timestamp(this.inMillis());
    }

    @Override
    public java.util.Date asDate() {
        return this._delegate.getTime();
    }

    public GregorianCalendar asCalendar() {
        return (GregorianCalendar)this._delegate.clone();
    }

    @Override
    public Meridian getMeridian() {
        if (this.getHour() < 12) {
            return Meridian.AM;
        }
        return Meridian.PM;
    }

    @Override
    public int getHourAs12Hour() {
        int n = this.getHour();
        if (n == 0) {
            return 12;
        }
        if (n > 12) {
            return n - 12;
        }
        return n;
    }

    public TimeDuration diff(DateTime dateTime) {
        return new TimeDuration(this._delegate.getTimeInMillis() - dateTime._delegate.getTimeInMillis() + "ms");
    }

    public TimeDuration absDiff(DateTime dateTime) {
        return new TimeDuration(Math.abs(this._delegate.getTimeInMillis() - dateTime._delegate.getTimeInMillis()) + "ms");
    }

    public TimeDuration absDiff() {
        return new TimeDuration(Math.abs(this._delegate.getTimeInMillis() - System.currentTimeMillis()) + "ms");
    }

    public TimeDuration diff() {
        return this.diff(new DateTime());
    }

    @Override
    public int compareTo(DateTime dateTime) {
        return LongX.compareTo(this._delegate.getTimeInMillis(), dateTime._delegate.getTimeInMillis());
    }

    public TimeZone getTimeZone() {
        return this._delegate.getTimeZone();
    }

    public DateTime subtract(TimeDuration timeDuration) {
        return new DateTime(this.inMillis() - timeDuration.inMilliseconds());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof java.util.Date) {
            return object.equals(this.asDate());
        }
        if (object instanceof GregorianCalendar) {
            object.equals(this._delegate);
        }
        if (object instanceof DateTime) {
            DateTime dateTime = (DateTime)object;
            return this._delegate.getTimeInMillis() == dateTime._delegate.getTimeInMillis();
        }
        return false;
    }

    @Override
    public TimeOnly asTimeOnly() {
        return new TimeOnly(this.getHour(), this.getMinutes(), this.getSeconds(), this.getMillisecond());
    }

    @Override
    public DateOnly asDateOnly() {
        return new DateOnly(this.getYear(), this.getMonth(), this.getDay());
    }

    public int hashCode() {
        return new Long(this._delegate.getTimeInMillis()).hashCode();
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");
        simpleDateFormat.setTimeZone(this.getTimeZone());
        return simpleDateFormat.format(this.asDate());
    }

    public String asJavaScriptFormattedString() {
        return _javaScriptDateFormatter.format(this);
    }

    public String asFriendlyString() {
        return "";
    }

    public DateTime toTimeZone(String string) {
        return this.toTimeZone(TimeZone.getTimeZone(string));
    }

    public DateTime toTimeZone(TimeZone timeZone) {
        if (this._delegate.getTimeZone().equals(timeZone)) {
            return this;
        }
        this.getTimeZone();
        this.inMillis();
        DateTime dateTime = new DateTime(this._delegate);
        dateTime._delegate.setTimeZone(timeZone);
        return dateTime;
    }

    public DateTime toTimeZone(TimeZone timeZone, boolean bl) {
        this.getTimeZone();
        this.inMillis();
        DateTime dateTime = new DateTime(this._delegate);
        dateTime._delegate.setTimeZone(timeZone);
        return dateTime;
    }

    @Override
    public long inMillis() {
        return this._delegate.getTimeInMillis();
    }

    public static DateTime wrap(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return new DateTime(date);
    }

    @Override
    public DateTime asDateTime(DateOnly dateOnly) {
        return new DateTime(dateOnly, this.asTimeOnly());
    }

    @Override
    public DateTime asDateTime() {
        return this;
    }

    public boolean before(DateTime dateTime) {
        return this.lessThan(dateTime);
    }

    public boolean after(DateTime dateTime) {
        return this.greaterThan(dateTime);
    }

    public boolean isInTheFuture() {
        DateTime dateTime = new DateTime();
        return this.after(dateTime);
    }

    public boolean isInThePast() {
        DateTime dateTime = new DateTime();
        return this.before(dateTime);
    }

    public static DateTime create(Date date, Time time) {
        return new DateTime(date.getYear() < 1900 ? date.getYear() + 1900 : date.getYear(), date.getMonth() + 1, date.getDate(), time.getHours(), time.getMinutes(), time.getSeconds());
    }
}

