/*
 * Decompiled with CFR 0.152.
 */
package net.model3.chrono;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.model3.chrono.DateOnly;
import net.model3.collections.ListX;
import net.model3.collections.SetX;

public class DateRange
implements Iterable<DateOnly>,
Serializable {
    private static final long serialVersionUID = 9175277870025054098L;
    DateOnly _start;
    DateOnly _end;

    public DateRange() {
    }

    public DateRange(DateOnly dateOnly, DateOnly dateOnly2) {
        this._start = dateOnly;
        this._end = dateOnly2;
        if (this._end == null && this._start == null) {
            throw new NullPointerException();
        }
        if (this._start == null) {
            this._start = this._end;
        }
        if (this._end == null) {
            this._end = this._start;
        }
        if (this._end.lessThan(this._start)) {
            DateOnly dateOnly3 = this._end;
            this._end = this._start;
            this._start = dateOnly3;
        }
    }

    public DateRange(DateOnly dateOnly) {
        this(dateOnly, null);
    }

    public boolean contains(DateOnly dateOnly) {
        if (this._start == null) {
            return false;
        }
        return dateOnly.greaterThanOrEqual(this._start) && dateOnly.lessThanOrEqual(this._end);
    }

    public List<DateOnly> asList() {
        List<DateOnly> list = ListX.create();
        if (this._start != null) {
            DateOnly dateOnly = this._start;
            while (dateOnly.lessThanOrEqual(this._end)) {
                list.add(dateOnly);
                dateOnly = dateOnly.addDays(1);
            }
        }
        return list;
    }

    public Set<DateOnly> asSet() {
        Set<DateOnly> set = SetX.create();
        if (this._start != null) {
            DateOnly dateOnly = this._start;
            while (dateOnly.lessThanOrEqual(this._end)) {
                set.add(dateOnly);
                dateOnly = dateOnly.addDays(1);
            }
        }
        return set;
    }

    @Override
    public Iterator<DateOnly> iterator() {
        return this.asList().iterator();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._end == null ? 0 : this._end.hashCode());
        n = 31 * n + (this._start == null ? 0 : this._start.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DateRange dateRange = (DateRange)object;
        if (this._end == null ? dateRange._end != null : !this._end.equals(dateRange._end)) {
            return false;
        }
        return !(this._start == null ? dateRange._start != null : !this._start.equals(dateRange._start));
    }

    public String toString() {
        if (this._start == null) {
            return "null-range";
        }
        return this._start + " to " + this._end;
    }
}

