/*
 * Decompiled with CFR 0.152.
 */
package net.model3.chrono;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import net.model3.chrono.ChronoHelper;
import net.model3.chrono.DateFormatter;
import net.model3.chrono.DateProvider;
import net.model3.chrono.DateTime;
import net.model3.chrono.DayOfWeek;
import net.model3.chrono.Month;
import net.model3.chrono.TimeOnly;
import net.model3.lang.AbstractComparable;
import net.model3.lang.IntegerX;
import net.model3.lang.TimeDuration;

public class DateOnly
extends AbstractComparable<DateOnly>
implements DateProvider,
Serializable,
Externalizable {
    private static final long serialVersionUID = -1624294531988300321L;
    private static final DateFormatter _jsonDateFormatter = new DateFormatter("M/d/yyyy");
    private final GregorianCalendar _delegate;

    public DateOnly() {
        this._delegate = new GregorianCalendar();
        this._delegate.set(11, 0);
        this._delegate.set(12, 0);
        this._delegate.set(13, 0);
        this._delegate.set(14, 0);
    }

    public DateOnly(long l) {
        this._delegate = new GregorianCalendar();
        this._delegate.setTimeInMillis(l);
        this._delegate.set(11, 0);
        this._delegate.set(12, 0);
        this._delegate.set(13, 0);
        this._delegate.set(14, 0);
    }

    public DateOnly(GregorianCalendar gregorianCalendar) {
        this._delegate = gregorianCalendar;
    }

    public DateOnly(int n, Month month, int n2) {
        this(n, month.number(), n2);
    }

    private DateOnly(int n, int n2, int n3) {
        this._delegate = new GregorianCalendar();
        this._delegate.set(n, n2 - 1, n3, 0, 0, 0);
        this._delegate.set(14, 0);
    }

    public DateOnly(Date date) {
        this._delegate = new GregorianCalendar();
        this._delegate.set(date.getYear() + 1900, date.getMonth(), date.getDate(), 0, 0, 0);
        this._delegate.set(14, 0);
    }

    public TimeDuration diff(DateProvider dateProvider) {
        long l = dateProvider.inMillis() - this.inMillis();
        if (l < 0L) {
            l = -l;
        }
        return TimeDuration.fromMilliseconds(l);
    }

    public boolean before(DateOnly dateOnly) {
        return this.lessThan(dateOnly);
    }

    public boolean after(DateOnly dateOnly) {
        return this.greaterThan(dateOnly);
    }

    @Override
    public boolean isToday() {
        return ChronoHelper.Instance.isToday(this);
    }

    @Override
    public boolean isTomorrow() {
        return ChronoHelper.Instance.isTomorrow(this);
    }

    public DateOnly addDays(int n) {
        return this.add(5, n);
    }

    @Override
    public DateOnly add(int n, int n2) {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)this._delegate.clone();
        gregorianCalendar.add(n, n2);
        DateOnly dateOnly = new DateOnly(gregorianCalendar);
        return dateOnly;
    }

    @Override
    public int getYear() {
        return this._delegate.get(1);
    }

    public int getDecade() {
        return this.getYear() / 10 * 10;
    }

    @Override
    public Month getMonth() {
        return Month.values()[this.getMonthIndex()];
    }

    @Override
    public int getMonthNumber() {
        return this._delegate.get(2) + 1;
    }

    @Override
    public int getMonthIndex() {
        return this._delegate.get(2);
    }

    @Override
    public int getDay() {
        return this._delegate.get(5);
    }

    public java.sql.Date asSqlDate() {
        return new java.sql.Date(this.inMillis());
    }

    @Override
    public Date asDate() {
        return this._delegate.getTime();
    }

    public DateTime asFirstMomentInDay() {
        return this.asDateTime(TimeOnly.FIRST_MOMENT_IN_DAY);
    }

    public DateTime asLastMomentInDay() {
        return this.asDateTime(TimeOnly.LAST_MOMENT_IN_DAY);
    }

    public DateTime asDateTime(TimeOnly timeOnly) {
        return new DateTime(this, timeOnly);
    }

    @Override
    public int compareTo(DateOnly dateOnly) {
        if (dateOnly == null) {
            return 1;
        }
        return IntegerX.compareTo(new int[]{this.getYear(), this.getMonthNumber(), this.getDay()}, new int[]{dateOnly.getYear(), dateOnly.getMonthNumber(), dateOnly.getDay()});
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.getDay();
        n = 31 * n + this.getMonthNumber();
        n = 31 * n + this.getYear();
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DateOnly dateOnly = (DateOnly)object;
        return this.getYear() == dateOnly.getYear() && this.getDay() == dateOnly.getDay() && this.getMonth() == dateOnly.getMonth();
    }

    public DateOnly nextWeek() {
        return this.firstDayInWeek().addDays(7);
    }

    public DateOnly previousWeek() {
        return this.firstDayInWeek().addDays(-7);
    }

    public DateOnly firstDayInWeek() {
        int n = 1 - this._delegate.get(7);
        if (n == 0) {
            return this;
        }
        return this.addDays(n);
    }

    public DateOnly previousMonth() {
        return this.add(2, -1);
    }

    public DateOnly lastDayInWeek() {
        int n = 7 - this._delegate.get(7);
        if (n == 0) {
            return this;
        }
        return this.addDays(n);
    }

    @Override
    public long inMillis() {
        return this._delegate.getTimeInMillis();
    }

    public String toJSONString() {
        return '\"' + _jsonDateFormatter.format(this) + '\"';
    }

    public static DateOnly wrap(Date date) {
        return new DateOnly(date);
    }

    public int getWeekInYear() {
        return this._delegate.get(3);
    }

    @Override
    public DayOfWeek getDayOfWeek() {
        return DayOfWeek.values()[this._delegate.get(7) - 1];
    }

    @Override
    public DateOnly add(TimeDuration timeDuration) {
        return this.add(13, (int)timeDuration.inSeconds());
    }

    public String toString() {
        return this.getYear() + "-" + this.getMonth().number() + "-" + this.getDay();
    }

    @Override
    public DateTime asDateTime() {
        return new DateTime(this.inMillis());
    }

    @Override
    public DateOnly asDateOnly() {
        return this;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        short s = objectInput.readShort();
        byte by = objectInput.readByte();
        byte by2 = objectInput.readByte();
        this._delegate.set(s, by, by2, 0, 0, 0);
        this._delegate.set(14, 0);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeShort((short)this.getYear());
        objectOutput.writeByte((byte)this.getMonthIndex());
        objectOutput.writeByte((byte)this.getDay());
    }
}

